/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntOpUnOpGen;
import ghidra.pcode.emu.jit.gen.opnd.MpIntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitInt2CompOp;
import java.util.ArrayList;
import java.util.List;

public enum Int2CompOpGen implements IntOpUnOpGen<JitInt2CompOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<Emitter.Ent<N1, Types.TInt>> opForInt(Emitter<N0> em) {
        return Op.ineg(em);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<Emitter.Ent<N1, Types.TLong>> opForLong(Emitter<N0> em) {
        return Op.lneg(em);
    }

    static Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> prepOpndAndCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> opnd, boolean shiftCarry) {
        if (shiftCarry) {
            em = em.emit(Op::ldc__i, 32).emit(Op::lushr);
        }
        return em.emit(opnd::read).emit(Op::ldc__i, -1 >>> 32 - ((JitType.IntJitType)opnd.type()).size() * 8).emit(Op::ixor).emit(Op::invokestatic, GenConsts.TR_INTEGER, "toUnsignedLong", GenConsts.MDESC_INTEGER__TO_UNSIGNED_LONG, false).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::ladd);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Ent<Emitter.Bot, Types.TLong>> genMpIntLeg2CmpTakesAndGivesCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> opnd, boolean shiftCarry, Scope scope) {
        return em.emit(Int2CompOpGen::prepOpndAndCarry, opnd, shiftCarry).emit(Op::dup2__2).emit(Op::l2i).emit(opnd::write, scope);
    }

    static SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, Emitter.Bot> genMpIntLeg2CmpTakesCarry(Emitter<Emitter.Ent<Emitter.Bot, Types.TLong>> em, SimpleOpnd<Types.TInt, JitType.IntJitType> opnd, boolean shiftCarry, Scope scope) {
        return em.emit(Int2CompOpGen::prepOpndAndCarry, opnd, shiftCarry).emit(Op::l2i).emit(opnd::write, scope);
    }

    @Override
    public <THIS extends JitCompiledPassage> Emitter<Emitter.Bot> genRunMpInt(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitInt2CompOp op, JitType.MpIntJitType type, Scope scope) {
        Opnd.OpndEm<JitType.MpIntJitType, Emitter.Bot> opnd = gen.genReadToOpnd(em, localThis, op.u(), type, this.ext(), scope);
        em = opnd.em();
        List legs = opnd.opnd().type().castLegsLE(opnd.opnd());
        int legCount = type.legsAlloc();
        ArrayList outLegs = new ArrayList();
        Emitter emCarry = em.emit(Op::ldc__l, 1);
        for (int i = 0; i < legCount - 1; ++i) {
            SimpleOpnd.SimpleOpndEm result = emCarry.emit(Int2CompOpGen::genMpIntLeg2CmpTakesAndGivesCarry, legs.get(i), i != 0, scope);
            emCarry = result.em();
            outLegs.add(result.opnd());
        }
        SimpleOpnd.SimpleOpndEm result = emCarry.emit(Int2CompOpGen::genMpIntLeg2CmpTakesCarry, legs.getLast(), true, scope);
        em = result.em();
        outLegs.add(result.opnd());
        MpIntLocalOpnd out = MpIntLocalOpnd.of(type, "out", outLegs);
        return gen.genWriteFromOpnd(em, localThis, op.out(), out, this.ext(), scope);
    }
}

