/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.JitBytesPcodeExecutorStatePiece;
import ghidra.pcode.emu.jit.JitCompiler;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitOpUseModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.analysis.JitTypeModel;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.ExceptionHandler;
import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.FieldForContext;
import ghidra.pcode.emu.jit.gen.FieldForExitSlot;
import ghidra.pcode.emu.jit.gen.FieldForPcodeOp;
import ghidra.pcode.emu.jit.gen.FieldForSpaceIndirect;
import ghidra.pcode.emu.jit.gen.FieldForUserop;
import ghidra.pcode.emu.jit.gen.FieldForVarnode;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Fld;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Misc;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.SubScope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVar;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;

public class JitCodeGenerator<THIS extends JitCompiledPassage> {
    private final MethodHandles.Lookup lookup;
    final JitAnalysisContext context;
    final JitControlFlowModel cfm;
    final JitDataFlowModel dfm;
    final JitVarScopeModel vsm;
    final JitTypeModel tm;
    final JitAllocationModel am;
    final JitOpUseModel oum;
    private final Map<JitControlFlowModel.JitBlock, Lbl<Emitter.Bot>> blockLabels = new HashMap<JitControlFlowModel.JitBlock, Lbl<Emitter.Bot>>();
    private final Map<PcodeOp, ExceptionHandler> excHandlers = new LinkedHashMap<PcodeOp, ExceptionHandler>();
    private final Map<AddressSpace, FieldForSpaceIndirect> fieldsForSpaceIndirect = new HashMap<AddressSpace, FieldForSpaceIndirect>();
    private final Map<Address, FieldForArrDirect> fieldsForArrDirect = new HashMap<Address, FieldForArrDirect>();
    private final Map<RegisterValue, FieldForContext> fieldsForContext = new HashMap<RegisterValue, FieldForContext>();
    private final Map<VarnodeKey, FieldForVarnode> fieldsForVarnode = new HashMap<VarnodeKey, FieldForVarnode>();
    private final Map<PcodeOpKey, FieldForPcodeOp> fieldsForOp = new HashMap<PcodeOpKey, FieldForPcodeOp>();
    private final Map<String, FieldForUserop> fieldsForUserop = new HashMap<String, FieldForUserop>();
    private final Map<JitPassage.AddrCtx, FieldForExitSlot> fieldsForExitSlot = new HashMap<JitPassage.AddrCtx, FieldForExitSlot>();
    final String nameThis;
    final Types.TRef<THIS> typeThis;
    private final ClassWriter cw;
    private final ClassVisitor cv;

    public JitCodeGenerator(MethodHandles.Lookup lookup, JitAnalysisContext context, JitControlFlowModel cfm, JitDataFlowModel dfm, JitVarScopeModel vsm, JitTypeModel tm, JitAllocationModel am, JitOpUseModel oum) {
        this.lookup = lookup;
        this.context = context;
        this.cfm = cfm;
        this.dfm = dfm;
        this.vsm = vsm;
        this.tm = tm;
        this.am = am;
        this.oum = oum;
        JitPassage.AddrCtx entry = context.getPassage().getEntry();
        Object pkgThis = lookup.lookupClass().getPackageName().replace(".", "/");
        if (!((String)pkgThis).isEmpty()) {
            pkgThis = (String)pkgThis + "/";
        }
        this.nameThis = ((String)pkgThis + "Passage$at_" + String.valueOf(entry.address) + "_" + entry.biCtx.toString(16)).replace(":", "_").replace(" ", "_");
        this.typeThis = Types.refExtends(JitCompiledPassage.class, "L" + this.nameThis + ";");
        int flags = entry.address.getOffset() == -1L ? 0 : 3;
        this.cw = new ClassWriter(flags);
        this.cv = JitCompiler.ENABLE_DIAGNOSTICS.contains((Object)JitCompiler.Diag.TRACE_CLASS) ? new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.err)) : this.cw;
        this.cv.visit(61, 1, this.nameThis, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(JitCompiledPassage.class)});
        Fld.decl(this.cv, 26, GenConsts.T_STRING, "LANGUAGE_ID", context.getLanguage().getLanguageID().toString());
        Fld.decl(this.cv, 26, GenConsts.T_LANGUAGE, "LANGUAGE");
        Fld.decl(this.cv, 26, GenConsts.T_ADDRESS_FACTORY, "ADDRESS_FACTORY");
        Fld.decl(this.cv, 26, new TypeLiteral<List<JitPassage.AddrCtx>>(this){}, "ENTRIES");
        Fld.decl(this.cv, 18, GenConsts.T_JIT_PCODE_THREAD, "thread");
        Fld.decl(this.cv, 18, GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE, "state");
        var paramsThread = new Object(this){
            Local<Types.TRef<THIS>> this_;
        };
        Methods.RetReqEm retThread = Emitter.start(this.typeThis, this.cv, 1, "thread", Methods.MthDesc.returns(GenConsts.T_JIT_PCODE_THREAD).build()).param(Methods.Def::done, this.typeThis, l -> {
            paramsThread.this_ = l;
        });
        retThread.em().emit(Op::aload, paramsThread.this_).emit(Op::getfield, this.typeThis, "thread", GenConsts.T_JIT_PCODE_THREAD).emit(Op::areturn, retThread.ret()).emit(Misc::finish);
    }

    public JitAnalysisContext getAnalysisContext() {
        return this.context;
    }

    public JitVarScopeModel getVariableScopeModel() {
        return this.vsm;
    }

    public JitTypeModel getTypeModel() {
        return this.tm;
    }

    public JitAllocationModel getAllocationModel() {
        return this.am;
    }

    protected Emitter<Emitter.Bot> startClInitMethod(Emitter<Emitter.Bot> em) {
        return em.emit(Op::getstatic, this.typeThis, "LANGUAGE_ID", GenConsts.T_STRING).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, "getLanguage", GenConsts.MDESC_JIT_COMPILED_PASSAGE__GET_LANGUAGE, true).step(Methods.Inv::takeArg).step(Methods.Inv::ret).emit(Op::dup).emit(Op::putstatic, this.typeThis, "LANGUAGE", GenConsts.T_LANGUAGE).emit(Op::invokeinterface, GenConsts.T_LANGUAGE, "getAddressFactory", GenConsts.MDESC_LANGUAGE__GET_ADDRESS_FACTORY).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::putstatic, this.typeThis, "ADDRESS_FACTORY", GenConsts.T_ADDRESS_FACTORY);
    }

    protected Emitter<Emitter.Bot> startInitMethod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TRef<JitPcodeThread>> localThread) {
        return em.emit(Op::aload, localThis).emit(Op::invokespecial, GenConsts.T_OBJECT, "<init>", GenConsts.MDESC_OBJECT__$INIT, false).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(Op::aload, localThis).emit(Op::aload, localThread).emit(Op::putfield, this.typeThis, "thread", GenConsts.T_JIT_PCODE_THREAD).emit(Op::aload, localThis).emit(Op::aload, localThread).emit(Op::invokevirtual, GenConsts.T_JIT_PCODE_THREAD, "getState", GenConsts.MDESC_JIT_PCODE_THREAD__GET_STATE, false).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::putfield, this.typeThis, "state", GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE);
    }

    protected <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<JitBytesPcodeExecutorStatePiece.JitBytesPcodeExecutorStateSpace>>> genLoadJitStateSpace(Emitter<N> em, Local<Types.TRef<THIS>> localThis, AddressSpace space) {
        return em.emit(Op::aload, localThis).emit(Op::getfield, this.typeThis, "state", GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE).emit(Op::getstatic, this.typeThis, "ADDRESS_FACTORY", GenConsts.T_ADDRESS_FACTORY).emit(Op::ldc__i, space.getSpaceID()).emit(Op::invokeinterface, GenConsts.T_ADDRESS_FACTORY, "getAddressSpace", GenConsts.MDESC_ADDRESS_FACTORY__GET_ADDRESS_SPACE).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::invokeinterface, GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE, "getForSpace", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE__GET_SPACE_FOR).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret);
    }

    public FieldForSpaceIndirect requestFieldForSpaceIndirect(AddressSpace space) {
        return this.fieldsForSpaceIndirect.computeIfAbsent(space, s -> {
            FieldForSpaceIndirect f = new FieldForSpaceIndirect((AddressSpace)s);
            return f;
        });
    }

    public FieldForArrDirect requestFieldForArrDirect(Address address) {
        return this.fieldsForArrDirect.computeIfAbsent(address, a -> {
            FieldForArrDirect f = new FieldForArrDirect((Address)a);
            return f;
        });
    }

    protected FieldForContext requestStaticFieldForContext(RegisterValue ctx) {
        return this.fieldsForContext.computeIfAbsent(ctx, c -> {
            FieldForContext f = new FieldForContext(ctx);
            return f;
        });
    }

    public FieldForVarnode requestStaticFieldForVarnode(Varnode vn) {
        return this.fieldsForVarnode.computeIfAbsent(new VarnodeKey(vn), vk -> {
            FieldForVarnode f = new FieldForVarnode(vn);
            return f;
        });
    }

    public FieldForPcodeOp requestStaticFieldForOp(PcodeOp op) {
        return this.fieldsForOp.computeIfAbsent(new PcodeOpKey(op), ok -> new FieldForPcodeOp(this, op));
    }

    public FieldForUserop requestFieldForUserop(PcodeUseropLibrary.PcodeUseropDefinition<byte[]> userop) {
        return this.fieldsForUserop.computeIfAbsent(userop.getName(), n -> {
            FieldForUserop f = new FieldForUserop(userop);
            return f;
        });
    }

    public FieldForExitSlot requestFieldForExitSlot(JitPassage.AddrCtx target) {
        return this.fieldsForExitSlot.computeIfAbsent(target, t -> {
            FieldForExitSlot f = new FieldForExitSlot((JitPassage.AddrCtx)t);
            return f;
        });
    }

    public Lbl<Emitter.Bot> labelForBlock(JitControlFlowModel.JitBlock block) {
        return this.blockLabels.computeIfAbsent(block, b -> Lbl.create());
    }

    public ExceptionHandler requestExceptionHandler(JitPassage.DecodedPcodeOp op, JitControlFlowModel.JitBlock block) {
        return this.excHandlers.computeIfAbsent(op, o -> new ExceptionHandler((PcodeOp)o, block));
    }

    protected <N extends Emitter.Next> Emitter<N> genValInit(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v) {
        return ValGen.lookup(v).genValInit(em, localThis, this, v);
    }

    public <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, T>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v, JT type, Opnd.Ext ext) {
        return ValGen.lookup(v).genReadToStack(em, localThis, this, v, type, ext);
    }

    public <N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genReadToOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return ValGen.lookup(v).genReadToOpnd(em, localThis, this, v, type, ext, scope);
    }

    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        return ValGen.lookup(v).genReadLegToStack(em, localThis, this, v, type, leg, ext);
    }

    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genReadToArray(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        return ValGen.lookup(v).genReadToArray(em, localThis, this, v, type, ext, scope, slack);
    }

    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadToBool(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVal v) {
        return ValGen.lookup(v).genReadToBool(em, localThis, this, v);
    }

    public <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> Emitter<N1> genWriteFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitVar v, JT type, Opnd.Ext ext, Scope scope) {
        return VarGen.lookup(v).genWriteFromStack(em, localThis, this, v, type, ext, scope);
    }

    public <N extends Emitter.Next> Emitter<N> genWriteFromOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitVar v, Opnd<JitType.MpIntJitType> opnd, Opnd.Ext ext, Scope scope) {
        return VarGen.lookup(v).genWriteFromOpnd(em, localThis, this, v, opnd, ext, scope);
    }

    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genWriteFromArray(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitVar v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return VarGen.lookup(v).genWriteFromArray(em, localThis, this, v, type, ext, scope);
    }

    protected OpGen.OpResult genOp(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, PcodeOp op, JitControlFlowModel.JitBlock block, int opIdx) {
        JitOp jitOp = this.dfm.getJitOp(op);
        if (!this.oum.isUsed(jitOp)) {
            return new OpGen.LiveOpResult(em);
        }
        try (SubScope scope = em.rootScope().sub();){
            OpGen.OpResult opResult = em.emit(Misc::lineNumber, opIdx).emit(OpGen.lookup(jitOp)::genRun, localThis, localCtxmod, retReq, this, jitOp, block, scope);
            return opResult;
        }
    }

    protected GenBlockResult genBlockOps(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitControlFlowModel.JitBlock block, int opIdx) {
        OpGen.OpResult result = new OpGen.LiveOpResult(em);
        for (PcodeOp op : block.getCode()) {
            if (!(result instanceof OpGen.LiveOpResult)) {
                throw new AssertionError((Object)"Control flow died mid-block");
            }
            OpGen.LiveOpResult live = result;
            result = this.genOp(live.em(), localThis, localCtxmod, retReq, op, block, opIdx);
            ++opIdx;
        }
        return new GenBlockResult(opIdx, result);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected GenBlockResult genBlock(OpGen.OpResult prev, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitControlFlowModel.JitBlock block, int opIdx) {
        Emitter em;
        OpGen.LiveOpResult live;
        OpGen.DeadOpResult r;
        if (block.hasJumpTo() || this.getOpEntry(block.first()) != null) {
            OpGen.OpResult opResult = prev;
            Objects.requireNonNull(opResult);
            OpGen.OpResult opResult2 = opResult;
            int n = 0;
            live = new OpGen.LiveOpResult(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OpGen.DeadOpResult.class, OpGen.LiveOpResult.class}, (Object)opResult2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    r = (OpGen.DeadOpResult)opResult2;
                    yield r.em().emit(Lbl::placeDead, this.labelForBlock(block));
                }
                case 1 -> {
                    OpGen.LiveOpResult r = (OpGen.LiveOpResult)opResult2;
                    yield r.em().emit(Lbl::place, this.labelForBlock(block));
                }
            });
        } else {
            OpGen.LiveOpResult r2;
            if (!(prev instanceof OpGen.LiveOpResult)) {
                Msg.warn((Object)this, (Object)("No control flow into block " + String.valueOf(block.start())));
                return new GenBlockResult(opIdx, prev);
            }
            live = r2 = (OpGen.LiveOpResult)prev;
        }
        r = block.first();
        if (r instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp first = (JitPassage.DecodedPcodeOp)((Object)r);
            if (this.context.getConfiguration().emitCounters()) {
                ExceptionHandler handler = this.requestExceptionHandler(first, block);
                Misc.TryCatchBlock<Throwable, Emitter.Bot> tryCatch = Misc.tryCatch(live.em(), Lbl.create(), handler.lbl(), GenConsts.T_THROWABLE);
                em = tryCatch.em().emit(Op::aload, localThis).emit(Op::ldc__i, block.instructionCount()).emit(Op::ldc__i, block.trailingOpCount()).emit(Op::invokeinterface, GenConsts.T_JIT_COMPILED_PASSAGE, "count", GenConsts.MDESC_JIT_COMPILED_PASSAGE__COUNT).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(Lbl::place, tryCatch.end());
                return this.genBlockOps(em, localThis, localCtxmod, retReq, block, opIdx);
            }
        }
        em = live.em();
        return this.genBlockOps(em, localThis, localCtxmod, retReq, block, opIdx);
    }

    protected <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<Address>>> genAddress(Emitter<N> em, Address address) {
        if (address == Address.NO_ADDRESS) {
            return em.emit(Op::getstatic, GenConsts.T_ADDRESS, "NO_ADDRESS", GenConsts.T_ADDRESS);
        }
        return em.emit(Op::getstatic, this.typeThis, "ADDRESS_FACTORY", GenConsts.T_ADDRESS_FACTORY).emit(Op::ldc__i, address.getAddressSpace().getSpaceID()).emit(Op::invokeinterface, GenConsts.T_ADDRESS_FACTORY, "getAddressSpace", GenConsts.MDESC_ADDRESS_FACTORY__GET_ADDRESS_SPACE).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::ldc__l, address.getOffset()).emit(Op::invokeinterface, GenConsts.T_ADDRESS_SPACE, "getAddress", GenConsts.MDESC_ADDRESS_SPACE__GET_ADDRESS).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret);
    }

    protected Emitter<Emitter.Bot> genStaticEntry(Emitter<Emitter.Bot> em, JitPassage.AddrCtx entry) {
        FieldForContext ctxField = this.requestStaticFieldForContext(entry.rvCtx);
        return em.emit(Op::getstatic, this.typeThis, "ENTRIES", GenConsts.T_LIST).emit(Op::new_, GenConsts.T_ADDR_CTX).emit(Op::dup).emit(ctxField::genLoad, this).emit(this::genAddress, entry.address).emit(Op::invokespecial, GenConsts.T_ADDR_CTX, "<init>", GenConsts.MDESC_ADDR_CTX__$INIT, false).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(Op::invokeinterface, GenConsts.T_LIST, "add", GenConsts.MDESC_LIST__ADD).step(Methods.Inv::takeRefArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::ret).emit(Op::pop);
    }

    protected Emitter<Emitter.Bot> genStaticEntries(Emitter<Emitter.Bot> em) {
        em = em.emit(Op::new_, GenConsts.T_ARRAY_LIST).emit(Op::dup).emit(Op::invokespecial, GenConsts.T_ARRAY_LIST, "<init>", GenConsts.MDESC_ARRAY_LIST__$INIT, false).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(Op::putstatic, this.typeThis, "ENTRIES", GenConsts.T_LIST);
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitPassage.AddrCtx entry = this.getOpEntry(block.first());
            if (entry == null) continue;
            em = this.genStaticEntry(em, entry);
        }
        return em;
    }

    protected Emitter<Emitter.Bot> genClInitMethod(Emitter<Emitter.Bot> em) {
        for (FieldForContext fCtx : this.fieldsForContext.values()) {
            em = fCtx.genClInitCode(em, this, this.cv);
        }
        for (FieldForVarnode fVn : this.fieldsForVarnode.values()) {
            em = fVn.genClInitCode(em, this, this.cv);
        }
        for (FieldForPcodeOp fOp : this.fieldsForOp.values()) {
            em = fOp.genClInitCode(em, this, this.cv);
        }
        return em;
    }

    protected Emitter<Emitter.Bot> genInitMethod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis) {
        for (JvmLocal<?, ?> local : this.am.allLocals()) {
            em = local.genInit(em, this);
        }
        for (JitVal v : this.dfm.allValuesSorted()) {
            em = this.genValInit(em, localThis, v);
        }
        for (FieldForArrDirect fArr : this.fieldsForArrDirect.values()) {
            em = fArr.genInit(em, localThis, this, this.cv);
        }
        for (FieldForExitSlot fExit : this.fieldsForExitSlot.values()) {
            em = fExit.genInit(em, localThis, this, this.cv);
        }
        for (FieldForSpaceIndirect fSpace : this.fieldsForSpaceIndirect.values()) {
            em = fSpace.genInit(em, localThis, this, this.cv);
        }
        for (FieldForUserop fUserop : this.fieldsForUserop.values()) {
            em = fUserop.genInit(em, localThis, this, this.cv);
        }
        return em;
    }

    /*
     * WARNING - void declaration
     */
    protected Emitter<Emitter.Dead> genRunMethod(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localBlockId, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq) {
        void var10_13;
        Local<Types.TInt> localCtxmod = em.rootScope().decl(Types.T_INT, "ctxmod");
        em = em.emit(Op::ldc__i, 0).emit(Op::istore, localCtxmod);
        this.am.allocate(em.rootScope());
        LinkedHashMap entries = new LinkedHashMap();
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitPassage.AddrCtx entry = this.getOpEntry(block.first());
            if (entry == null) continue;
            entries.put(block, Lbl.create());
        }
        Lbl lblBadEntry = Lbl.create();
        Emitter dead = em.emit(Op::iload, localBlockId).emit(Op::tableswitch, 0, lblBadEntry, List.copyOf(entries.values()));
        for (Map.Entry entry : entries.entrySet()) {
            JitControlFlowModel.JitBlock block = (JitControlFlowModel.JitBlock)entry.getKey();
            dead = dead.emit(Lbl::placeDead, (Lbl)entry.getValue()).emit(VarGen.computeBlockTransition(localThis, this, null, block)::genFwd).emit(Op::goto_, this.labelForBlock(block));
        }
        dead = dead.emit(Lbl::placeDead, lblBadEntry).emit(Op::new_, GenConsts.T_ILLEGAL_ARGUMENT_EXCEPTION).emit(Op::dup).emit(Op::ldc__a, "Bad entry blockId").emit(Op::invokespecial, GenConsts.T_ILLEGAL_ARGUMENT_EXCEPTION, "<init>", GenConsts.MDESC_ILLEGAL_ARGUMENT_EXCEPTION__$INIT, false).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid).emit(Op::athrow);
        int opIdx = 1;
        OpGen.DeadOpResult deadOpResult = new OpGen.DeadOpResult(dead);
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            OpGen.OpResult opResult;
            GenBlockResult blockResult = this.genBlock((OpGen.OpResult)var10_13, localThis, localCtxmod, retReq, block, opIdx);
            opIdx = blockResult.opIdx;
            JitControlFlowModel.JitBlock fall = block.getFallFrom();
            if (fall == null) {
                OpGen.OpResult opResult2 = blockResult.opResult;
                if (!(opResult2 instanceof OpGen.DeadOpResult)) {
                    throw new AssertionError((Object)"No fall-through, but control flow is live");
                }
                OpGen.DeadOpResult r = (OpGen.DeadOpResult)opResult2;
                OpGen.DeadOpResult deadOpResult2 = r;
                continue;
            }
            Objects.requireNonNull(blockResult.opResult);
            int n = 0;
            Record record = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OpGen.LiveOpResult.class, OpGen.DeadOpResult.class}, (Object)opResult, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    OpGen.LiveOpResult r = (OpGen.LiveOpResult)opResult;
                    yield new OpGen.LiveOpResult(r.em().emit(VarGen.computeBlockTransition(localThis, this, block, fall)::genFwd));
                }
                case 1 -> {
                    OpGen.DeadOpResult r = (OpGen.DeadOpResult)opResult;
                    Msg.warn((Object)this, (Object)"Fall-through block resulted in dead control flow.");
                    yield r;
                }
            };
        }
        if (!(var10_13 instanceof OpGen.DeadOpResult)) {
            throw new AssertionError((Object)"Final block left live control flow");
        }
        OpGen.DeadOpResult r = (OpGen.DeadOpResult)var10_13;
        dead = r.em();
        for (ExceptionHandler handler : this.excHandlers.values()) {
            dead = dead.emit(handler::genRun, localThis, this);
        }
        return dead;
    }

    public JitCompiledPassageClass load() {
        byte[] bytes = this.generate();
        return JitCompiledPassageClass.load(this.lookup, bytes);
    }

    protected byte[] dumpBytecode(byte[] bytes) {
        File dest = new File("build/gen/" + this.nameThis + ".class");
        dest.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(dest);){
            ((OutputStream)os).write(bytes);
            new ProcessBuilder("javap", "-c", "-l", dest.getPath()).inheritIO().start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            Msg.warn((Object)this, (Object)("Could not dump class file: " + this.nameThis + " (" + String.valueOf(e) + ")"));
        }
        return bytes;
    }

    protected byte[] generate() {
        var paramsRun = new Object(this){
            Local<Types.TRef<THIS>> this_;
            Local<Types.TInt> blockId;
        };
        Methods.RetReqEm retRun = Emitter.start(this.typeThis, this.cv, 1, "run", Methods.MthDesc.returns(GenConsts.T_ENTRY_POINT).param(Types.T_INT).build()).param(Methods.Def::param, Types.T_INT, "blockId", l -> {
            paramsRun.blockId = l;
        }).param(Methods.Def::done, this.typeThis, l -> {
            paramsRun.this_ = l;
        });
        retRun.em().emit(this::genRunMethod, paramsRun.this_, paramsRun.blockId, retRun.ret()).emit(Misc::finish);
        var paramsInit = new Object(this){
            Local<Types.TRef<THIS>> this_;
            Local<Types.TRef<JitPcodeThread>> thread;
        };
        Methods.RetReqEm retInit = Emitter.start(this.typeThis, this.cv, 1, "<init>", Methods.MthDesc.returns(Types.T_VOID).param(GenConsts.T_JIT_PCODE_THREAD).build()).param(Methods.Def::param, GenConsts.T_JIT_PCODE_THREAD, "thread", l -> {
            paramsInit.thread = l;
        }).param(Methods.Def::done, this.typeThis, l -> {
            paramsInit.this_ = l;
        });
        retInit.em().emit(this::startInitMethod, paramsInit.this_, paramsInit.thread).emit(this::genInitMethod, paramsInit.this_).emit(Op::return_, retInit.ret()).emit(Misc::finish);
        Methods.RetReqEm retClInit = Emitter.start(this.cv, 1, "<clinit>", Methods.MthDesc.returns(Types.T_VOID).build()).param(Methods.Def::done);
        retClInit.em().emit(this::startClInitMethod).emit(this::genClInitMethod).emit(this::genStaticEntries).emit(Op::return_, retClInit.ret()).emit(Misc::finish);
        this.cv.visitEnd();
        if (JitCompiler.ENABLE_DIAGNOSTICS.contains((Object)JitCompiler.Diag.DUMP_CLASS)) {
            return this.dumpBytecode(this.cw.toByteArray());
        }
        return this.cw.toByteArray();
    }

    public JitPassage.AddrCtx getOpEntry(PcodeOp op) {
        return this.context.getOpEntry(op);
    }

    public RegisterValue getExitContext(PcodeOp op) {
        if (op instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp dec = (JitPassage.DecodedPcodeOp)op;
            return dec.getContext();
        }
        throw new AssertionError((Object)("Couldn't figure exit context for " + String.valueOf(op)));
    }

    public <N extends Emitter.Next> Emitter<N> genRetirePcCtx(Emitter<N> em, Local<Types.TRef<THIS>> localThis, PcGen pcGen, RegisterValue ctx, RetireMode mode) {
        return em.emit(Op::aload, localThis).emit(pcGen::gen).emit(c -> ctx == null ? c.emit(Op::aconst_null, GenConsts.T_REGISTER_VALUE) : c.emit(this.requestStaticFieldForContext(ctx)::genLoad, this)).emit(Op::invokeinterface, GenConsts.T_JIT_COMPILED_PASSAGE, mode.mname, GenConsts.MDESC_JIT_COMPILED_PASSAGE__SET_$OR_WRITE_COUNTER_AND_CONTEXT).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid);
    }

    public <N extends Emitter.Next> Emitter<N> genExit(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitControlFlowModel.JitBlock block, PcGen pcGen, RegisterValue ctx) {
        return em.emit(VarGen.computeBlockTransition(localThis, this, block, null)::genFwd).emit(this::genRetirePcCtx, localThis, pcGen, ctx, RetireMode.WRITE);
    }

    public String getErrorMessage(PcodeOp op) {
        return this.context.getErrorMessage(op);
    }

    public Address getAddressForOp(PcodeOp op) {
        if (op instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp dec = (JitPassage.DecodedPcodeOp)op;
            return dec.getCounter();
        }
        return op.getSeqnum().getTarget();
    }

    public JitType resolveType(JitVal val, JitTypeBehavior type) {
        return type.resolve(this.tm.typeOf(val));
    }

    record VarnodeKey(int space, long offset, int size) {
        public VarnodeKey(Varnode vn) {
            this(vn == null ? 0 : vn.getSpace(), vn == null ? 0L : vn.getOffset(), vn == null ? 0 : vn.getSize());
        }
    }

    record PcodeOpKey(VarnodeKey out, int opcode, List<VarnodeKey> ins) {
        public PcodeOpKey(PcodeOp op) {
            this(new VarnodeKey(op.getOutput()), op.getOpcode(), Stream.of(op.getInputs()).map(VarnodeKey::new).toList());
        }
    }

    record GenBlockResult(int opIdx, OpGen.OpResult opResult) {
    }

    public static interface PcGen {
        public static PcGen loadOffset(final Address address) {
            return new PcGen(){

                @Override
                public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> gen(Emitter<N> em) {
                    return em.emit(Op::ldc__l, address.getOffset());
                }
            };
        }

        public static <THIS extends JitCompiledPassage> PcGen loadTarget(final Local<Types.TRef<THIS>> localThis, final JitCodeGenerator<THIS> gen, final JitVal target) {
            return new PcGen(){

                @Override
                public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> gen(Emitter<N> em) {
                    return gen.genReadToStack(em, localThis, target, JitType.LongJitType.I8, Opnd.Ext.ZERO);
                }
            };
        }

        public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> gen(Emitter<N> var1);
    }

    public static enum RetireMode {
        WRITE("writeCounterAndContext"),
        SET("setCounterAndContext");

        private String mname;

        private RetireMode(String mname) {
            this.mname = mname;
        }
    }

    public static class LineNumberer {
        final MethodVisitor mv;
        int nextLine = 1;

        public LineNumberer(MethodVisitor mv) {
            this.mv = mv;
        }

        public void nextLine() {
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(this.nextLine++, label);
        }
    }
}

