/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.alloc.IntInLongHandler;
import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.alloc.LongInLongHandler;
import ghidra.pcode.emu.jit.alloc.SimpleVarHandler;
import ghidra.pcode.emu.jit.alloc.VarHandler;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class LongVarAlloc
extends Record
implements SimpleVarHandler<Types.TLong, JitType.LongJitType> {
    private final JvmLocal<Types.TLong, JitType.LongJitType> local;
    private final JitType.LongJitType type;

    public LongVarAlloc(JvmLocal<Types.TLong, JitType.LongJitType> local, JitType.LongJitType type) {
        this.local = local;
        this.type = type;
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadLegToStack(Emitter<N> em, JitCodeGenerator<?> gen, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        return this.genLoadLegToStackC2(em, gen, type, leg, ext);
    }

    @Override
    public Opnd.MpToStackConv<Types.TInt, JitType.IntJitType, JitType.MpIntJitType, Types.TLong, JitType.LongJitType> getConvToStack() {
        return Opnd.MpIntToLong.INSTANCE;
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genLoadToBool(Emitter<N> em, JitCodeGenerator<?> gen) {
        return em.emit(this::genLoadToStack, gen, this.type, Opnd.Ext.ZERO).emit(Op::ldc__l, 0).emit(Op::lcmp);
    }

    @Override
    public VarHandler subpiece(Endian endian, int byteOffset, int maxByteSize) {
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(endian, this.local.vn(), byteOffset, Math.min(this.type.size(), maxByteSize));
        if (byteOffset == 0) {
            return new LongVarAlloc(this.local, JitType.LongJitType.forSize(subVn.getSize()));
        }
        if (subVn.getSize() <= 4) {
            return new IntInLongHandler(this.local, JitType.IntJitType.forSize(subVn.getSize()), subVn, byteOffset);
        }
        return new LongInLongHandler(this.local, JitType.LongJitType.forSize(subVn.getSize()), subVn, byteOffset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this, o);
    }

    @Override
    public JvmLocal<Types.TLong, JitType.LongJitType> local() {
        return this.local;
    }

    @Override
    public JitType.LongJitType type() {
        return this.type;
    }
}

