/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.alloc;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.Varnode;

public record JvmLocal<T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>>(Local<T> local, JT type, Varnode vn, SimpleOpnd<T, JT> opnd) {
    public static <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>> JvmLocal<T, JT> of(Local<T> local, JT type, Varnode vn) {
        SimpleOpnd<T, JT> opnd = SimpleOpnd.of(type, local);
        return new JvmLocal<T, JT>(local, type, vn, opnd);
    }

    public String name() {
        return this.local.name();
    }

    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>> JvmLocal<TT, TJT> castOf(TJT type) {
        if (this.type != type) {
            throw new ClassCastException("JvmLocal is not of the given type: this is %s. Requested is %s.".formatted(this.type, type));
        }
        return this;
    }

    public <N extends Emitter.Next> Emitter<N> genInit(Emitter<N> em, JitCodeGenerator<?> gen) {
        return VarGen.genVarnodeInit(em, gen, this.vn);
    }

    public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, TT>> genLoadToStack(Emitter<N> em, JitCodeGenerator<?> gen, TJT type, Opnd.Ext ext) {
        return em.emit(this.opnd::read).emit(Opnd::convert, this.type, type, ext);
    }

    public <FT extends Types.BPrim<?>, FJT extends JitType.SimpleJitType<FT, FJT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, FT>> Emitter<N1> genStoreFromStack(Emitter<N0> em, JitCodeGenerator<?> gen, FJT type, Opnd.Ext ext, Scope scope) {
        return em.emit(Opnd::convert, type, this.type, ext).emit(this.opnd::writeDirect);
    }

    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genBirthCode(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen) {
        return em.emit(VarGen::genReadValDirectToStack, localThis, gen, this.type, this.vn).emit(this.opnd::writeDirect);
    }

    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genRetireCode(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen) {
        return em.emit(this.opnd::read).emit(VarGen::genWriteValDirectFromStack, localThis, gen, this.type, this.vn);
    }

    public Address maxPrimAddr() {
        return this.vn.getAddress().add((long)(this.type.ext().size() - 1));
    }
}

