/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator.memory;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.util.Arrays;

@Deprecated(since="12.1", forRemoval=true)
public class ProgramLoadImage {
    private Program program;
    private AddressSetView initializedAddressSet;
    private MemoryFaultHandler faultHandler;

    public ProgramLoadImage(Program program, MemoryFaultHandler faultHandler) {
        this.program = program;
        Memory memory = program.getMemory();
        this.initializedAddressSet = memory.getLoadedAndInitializedAddressSet();
        for (MemoryBlock block : memory.getBlocks()) {
            if (block.isInitialized() || !block.isMapped()) continue;
            this.initializedAddressSet = this.addMappedInitializedMemory(block);
        }
        this.faultHandler = faultHandler;
    }

    private AddressSetView addMappedInitializedMemory(MemoryBlock mappedBlock) {
        MemoryBlockSourceInfo sourceInfo = (MemoryBlockSourceInfo)mappedBlock.getSourceInfos().get(0);
        if (!sourceInfo.getMappedRange().isPresent()) {
            throw new AssertException("Mapped block did not have mapped range!");
        }
        AddressRange mappedRange = (AddressRange)sourceInfo.getMappedRange().get();
        Address mapStart = mappedRange.getMinAddress();
        Address mapEnd = mappedRange.getMaxAddress();
        AddressSet modifiedSet = new AddressSet(this.initializedAddressSet);
        AddressSet mappedAreas = this.initializedAddressSet.intersectRange(mapStart, mapEnd);
        for (AddressRange range : mappedAreas) {
            Address start = mappedBlock.getStart().add(range.getMinAddress().subtract(mapStart));
            Address end = mappedBlock.getStart().add(range.getMaxAddress().subtract(mapStart));
            modifiedSet.add(start, end);
        }
        return modifiedSet;
    }

    public void dispose() {
    }

    public void write(byte[] bytes, int size, Address addr, int offset) {
        Address endAddr;
        Memory memory = this.program.getMemory();
        int currentOffset = offset;
        int remaining = size;
        Address nextAddr = addr;
        try {
            endAddr = addr.addNoWrap((long)(size - 1));
        }
        catch (AddressOverflowException e) {
            throw new LowlevelError("Illegal memory write request: " + String.valueOf(addr) + ", length=" + size + " bytes");
        }
        while (true) {
            AddressRange range;
            int chunkSize = remaining;
            AddressRangeIterator it = this.initializedAddressSet.getAddressRanges(nextAddr, true);
            AddressRange addressRange = range = it.hasNext() ? (AddressRange)it.next() : null;
            if (range == null) {
                this.handleWriteFault(bytes, currentOffset, remaining, nextAddr);
                break;
            }
            if (range.contains(nextAddr)) {
                if (endAddr.compareTo((Object)range.getMaxAddress()) > 0) {
                    chunkSize = (int)(range.getMaxAddress().subtract(nextAddr) + 1L);
                }
                try {
                    memory.setBytes(nextAddr, bytes, currentOffset, chunkSize);
                }
                catch (MemoryAccessException e) {
                    throw new LowlevelError("Unexpected memory write error: " + e.getMessage());
                }
            } else {
                Address rangeAddr = range.getMinAddress();
                if (!rangeAddr.getAddressSpace().equals((Object)addr.getAddressSpace())) {
                    this.handleWriteFault(bytes, currentOffset, remaining, nextAddr);
                    break;
                }
                long gapSize = rangeAddr.subtract(nextAddr);
                chunkSize = (int)Math.min(gapSize, (long)remaining);
                this.handleWriteFault(bytes, currentOffset, chunkSize, nextAddr);
            }
            if (chunkSize == remaining) break;
            try {
                nextAddr = nextAddr.addNoWrap((long)chunkSize);
            }
            catch (AddressOverflowException e) {
                throw new LowlevelError("Unexpected error: " + e.getMessage());
            }
            currentOffset += chunkSize;
            remaining -= chunkSize;
        }
    }

    private void handleWriteFault(byte[] bytes, int currentOffset, int remaining, Address nextAddr) {
    }

    public byte[] read(byte[] bytes, int size, Address addr, int offset, boolean generateInitializedMask) {
        Address endAddr;
        Memory memory = this.program.getMemory();
        int currentOffset = offset;
        int remaining = size;
        Address nextAddr = addr;
        byte[] initializedMask = null;
        try {
            endAddr = addr.addNoWrap((long)(size - 1));
        }
        catch (AddressOverflowException e) {
            throw new LowlevelError("Illegal memory read request: " + String.valueOf(addr) + ", length=" + size + " bytes");
        }
        while (true) {
            AddressRange range;
            int chunkSize = remaining;
            AddressRangeIterator it = this.initializedAddressSet.getAddressRanges(nextAddr, true);
            AddressRange addressRange = range = it.hasNext() ? (AddressRange)it.next() : null;
            if (range == null) {
                if (generateInitializedMask) {
                    initializedMask = ProgramLoadImage.getInitializedMask(bytes.length, offset, currentOffset, remaining, initializedMask);
                    break;
                }
                this.handleReadFault(bytes, currentOffset, remaining, nextAddr);
                break;
            }
            if (range.contains(nextAddr)) {
                if (endAddr.compareTo((Object)range.getMaxAddress()) > 0) {
                    chunkSize = (int)(range.getMaxAddress().subtract(nextAddr) + 1L);
                }
                try {
                    memory.getBytes(nextAddr, bytes, currentOffset, chunkSize);
                }
                catch (MemoryAccessException e) {
                    Msg.warn((Object)this, (Object)("Unexpected memory read error: " + e.getMessage()));
                }
            } else {
                Address rangeAddr = range.getMinAddress();
                if (!rangeAddr.getAddressSpace().equals((Object)addr.getAddressSpace())) {
                    if (generateInitializedMask) {
                        initializedMask = ProgramLoadImage.getInitializedMask(bytes.length, offset, currentOffset, remaining, initializedMask);
                        break;
                    }
                    this.handleReadFault(bytes, currentOffset, remaining, nextAddr);
                    break;
                }
                long gapSize = rangeAddr.subtract(nextAddr);
                int n = chunkSize = gapSize > 0L ? (int)Math.min(gapSize, (long)remaining) : remaining;
                if (generateInitializedMask) {
                    initializedMask = ProgramLoadImage.getInitializedMask(bytes.length, offset, currentOffset, chunkSize, initializedMask);
                } else {
                    this.handleReadFault(bytes, currentOffset, chunkSize, nextAddr);
                }
            }
            if (chunkSize == remaining) break;
            try {
                nextAddr = nextAddr.addNoWrap((long)chunkSize);
            }
            catch (AddressOverflowException e) {
                throw new LowlevelError("Unexpected error: " + e.getMessage());
            }
            currentOffset += chunkSize;
            remaining -= chunkSize;
        }
        return initializedMask;
    }

    private static byte[] getInitializedMask(int bufsize, int initialOffset, int uninitializedOffset, int uninitializedSize, byte[] initializedMask) {
        if (initializedMask == null) {
            initializedMask = MemoryPage.getInitializedMask(bufsize, 0, initialOffset, false);
        }
        MemoryPage.setUninitialized(initializedMask, uninitializedOffset, uninitializedSize);
        return initializedMask;
    }

    private void handleReadFault(byte[] bytes, int offset, int size, Address addr) {
        Arrays.fill(bytes, offset, offset + size, (byte)0);
        if (this.faultHandler != null) {
            this.faultHandler.uninitializedRead(addr, size, bytes, size);
        }
    }

    public AddressSetView getInitializedAddressSet() {
        return this.initializedAddressSet;
    }
}

