/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.pdb.classtype.ClassTypeManager;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.PointerDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class VxtManager {
    protected ClassTypeManager ctm;
    protected TreeMap<Address, VirtualBaseTable> vbtByAddress;
    protected TreeMap<Address, VirtualFunctionTable> vftByAddress;

    public VxtManager(ClassTypeManager ctm) {
        this.ctm = ctm;
        this.vbtByAddress = new TreeMap();
        this.vftByAddress = new TreeMap();
    }

    public PointerDataType getDefaultVbtPtr() {
        return this.ctm.getDefaultVbtPtr();
    }

    public PointerDataType getDefaultVftPtr() {
        return this.ctm.getDefaultVftPtr();
    }

    public VirtualBaseTable getVbt(Address address) {
        return this.vbtByAddress.get(address);
    }

    public VirtualFunctionTable getVft(Address address) {
        return this.vftByAddress.get(address);
    }

    public List<Address> dumpVbtAddresses() {
        return new ArrayList<Address>(this.vbtByAddress.keySet());
    }

    public List<Address> dumpVftAddresses() {
        return new ArrayList<Address>(this.vftByAddress.keySet());
    }
}

