/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import docking.widgets.search.SearchLocationContext;
import docking.widgets.search.SearchLocationContextBuilder;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.services.DataTypeReference;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Function;
import ghidra.util.StringUtilities;
import java.util.List;

public abstract class DecompilerReference {
    protected ClangLine line;
    protected ClangToken sourceToken;
    protected DecompilerVariable variable;

    protected DecompilerReference(ClangLine line, ClangToken token) {
        this.line = line;
        this.sourceToken = token;
        if (token != null) {
            this.variable = new DecompilerVariableType(token);
        }
    }

    public abstract void accumulateMatches(DataType var1, FieldMatcher var2, List<DataTypeReference> var3);

    public DecompilerVariable getVariable() {
        return this.variable;
    }

    public DataType getDataType() {
        return this.variable.getDataType();
    }

    public Function getFunction() {
        Function function = this.variable.getFunction();
        return function;
    }

    public Address getAddress() {
        return this.variable.getAddress();
    }

    public Address getAddress(DecompilerVariable var) {
        return var.getAddress();
    }

    public ClangLine getLine() {
        return this.line;
    }

    protected SearchLocationContext getContext() {
        SearchLocationContext context = this.getContext(this.variable);
        return context;
    }

    protected SearchLocationContext getContext(DecompilerVariable var) {
        SearchLocationContextBuilder builder = new SearchLocationContextBuilder();
        builder.append(this.line.getLineNumber() + ": ");
        List tokens = this.line.getAllTokens();
        for (ClangToken token : tokens) {
            if (token.equals(var.variable)) {
                builder.appendMatch(token.getText());
                continue;
            }
            builder.append(token.getText());
        }
        return builder.build();
    }

    public static boolean isEquivalent(DataType dt1, DataType dt2) {
        DataType base1 = DecompilerReference.getBaseType(dt1);
        DataType base2 = DecompilerReference.getBaseType(dt2);
        if (base1 == null || base2 == null) {
            return false;
        }
        return base1.isEquivalent(base2);
    }

    public static boolean isEqual(DataType dt1, DataType dt2) {
        DataType base1 = DecompilerReference.getBaseType(dt1);
        DataType base2 = DecompilerReference.getBaseType(dt2);
        if (base1 == null || base2 == null) {
            return false;
        }
        return base1.equals((Object)base2);
    }

    public static DataType getBaseType(DataType dt) {
        if (dt instanceof Array) {
            return DecompilerReference.getBaseType(((Array)dt).getDataType());
        }
        if (dt instanceof Pointer) {
            DataType baseDataType = ((Pointer)dt).getDataType();
            if (baseDataType != null) {
                return DecompilerReference.getBaseType(baseDataType);
            }
        } else if (dt instanceof TypeDef) {
            DataType baseDataType = ((TypeDef)dt).getBaseDataType();
            return DecompilerReference.getBaseType(baseDataType);
        }
        return dt;
    }

    public static DataType getFieldDataType(ClangFieldToken field) {
        DataType fieldDt = field.getDataType();
        if ((fieldDt = DecompilerReference.getBaseType(fieldDt)) instanceof Structure) {
            DataTypeComponent dtc;
            Structure parent = (Structure)fieldDt;
            int offset = field.getOffset();
            int n = parent.getLength();
            if (offset >= 0 && offset < n && (dtc = parent.getComponentContaining(field.getOffset())) != null) {
                return dtc.getDataType();
            }
        } else if (fieldDt instanceof Union) {
            Union union = (Union)fieldDt;
            String fieldName = field.getText();
            int n = union.getNumComponents();
            for (int i = 0; i < n; ++i) {
                DataTypeComponent unionDtc = union.getComponent(i);
                String dtcName = unionDtc.getFieldName();
                if (!fieldName.equals(dtcName)) continue;
                return unionDtc.getDataType();
            }
        }
        return fieldDt;
    }

    public String toString() {
        return "{\n\tvariable: " + StringUtilities.toStringWithIndent((Object)this.variable) + ",\n\tdata type: " + String.valueOf(this.getDataType()) + ",\n\tline " + StringUtilities.toStringWithIndent((Object)this.getContext().getPlainText()) + ",\n\tfunction: " + String.valueOf(this.getFunction()) + "\n}";
    }
}

