/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint;

import ghidra.debug.api.emulation.EmulatorFactory;
import ghidra.debug.api.emulation.PcodeDebuggerAccess;
import ghidra.pcode.emu.PcodeEmulationCallbacks;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.taint.TaintPcodeEmulator;
import ghidra.pcode.emu.taint.state.TaintPieceHandler;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.taint.model.TaintVec;
import org.apache.commons.lang3.tuple.Pair;

public class TaintEmulatorFactory
implements EmulatorFactory {
    public static TraceEmulationIntegration.Writer delayedWriteTrace(PcodeTraceAccess access) {
        TraceEmulationIntegration.Writer writer = TraceEmulationIntegration.bytesDelayedWrite((PcodeTraceAccess)access);
        TaintEmulatorFactory.addHandlers(writer);
        return writer;
    }

    public static void addHandlers(TraceEmulationIntegration.Writer writer) {
        writer.putHandler((TraceEmulationIntegration.PieceHandler)new TaintPieceHandler());
    }

    public String getTitle() {
        return "Taint Analyzer with Concrete Emulation";
    }

    public PcodeMachine<?> create(PcodeDebuggerAccess access, TraceEmulationIntegration.Writer writer) {
        TaintEmulatorFactory.addHandlers(writer);
        return new TaintPcodeEmulator(access.getLanguage(), (PcodeEmulationCallbacks<Pair<byte[], TaintVec>>)writer.callbacks());
    }
}

