/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.tree.AnyChangeTreeModelListener;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectDialog;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerPlugin;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiManagerActionContext;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiAcceptorNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiConnectionNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiManagerNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiServiceNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiTargetNode;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRmiService;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeModelListener;

public class TraceRmiConnectionManagerProvider
extends ComponentProviderAdapter {
    public static final String TITLE = "Connections";
    public static final Icon ICON = DebuggerResources.ICON_CONNECTION;
    public static final HelpLocation HELP = new HelpLocation(PluginUtils.getPluginNameFromClass(TraceRmiConnectionManagerPlugin.class), "plugin");
    private static final String GROUP_SERVER = "2. Server";
    private static final String GROUP_CONNECT = "1. Connect";
    private static final String GROUP_MAINTENANCE = "3. Maintenance";
    private final TraceRmiConnectionManagerPlugin plugin;
    TraceRmiService traceRmiService;
    DebuggerTargetService targetService;
    @AutoServiceConsumed
    DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    DebuggerTraceManagerService traceManagerService;
    @AutoServiceConsumed
    DebuggerControlService controlService;
    private final AutoService.Wiring autoServiceWiring;
    private JPanel mainPanel;
    protected GTree tree;
    protected TraceRmiServiceNode rootNode = new TraceRmiServiceNode(this);
    DockingAction actionStartServer;
    DockingAction actionStopServer;
    DockingAction actionConnectAccept;
    DockingAction actionConnectOutbound;
    DockingAction actionCloseConnection;
    DockingAction actionCloseAll;
    DockingAction actionForceCloseTransactions;
    TraceRmiManagerActionContext myActionContext;

    public TraceRmiConnectionManagerProvider(TraceRmiConnectionManagerPlugin plugin) {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle(TITLE);
        this.setIcon(ICON);
        this.setHelpLocation(HELP);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.setVisible(true);
        this.createActions();
    }

    private void buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.tree = new InjectableGTree(this.rootNode);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.mainPanel.add((Component)this.tree);
        this.tree.getGTSelectionModel().addGTreeSelectionListener(evt -> this.setContext());
        this.tree.addGTModelListener((TreeModelListener)((AnyChangeTreeModelListener)e -> this.setContext()));
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    TraceRmiConnectionManagerProvider.this.activateSelectedNode();
                    e.consume();
                }
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TraceRmiConnectionManagerProvider.this.activateSelectedNode();
                    e.consume();
                }
            }
        });
    }

    private void activateSelectedNode() {
        List selList = this.tree.getSelectedNodes();
        if (selList.isEmpty()) {
            return;
        }
        assert (selList.size() == 1);
        GTreeNode sel = (GTreeNode)selList.get(0);
        this.nodeActivated((TraceRmiManagerNode)sel);
    }

    private void nodeActivated(TraceRmiManagerNode node) {
        if (node instanceof TraceRmiTargetNode) {
            TraceRmiTargetNode tNode = (TraceRmiTargetNode)node;
            if (this.traceManagerService == null) {
                return;
            }
            Target target = tNode.getTarget();
            this.traceManagerService.activateTarget(target);
            if (this.controlService == null) {
                return;
            }
            if (!this.controlService.getCurrentMode(target.getTrace()).isTarget()) {
                this.controlService.setCurrentMode(target.getTrace(), ControlMode.RO_TARGET);
            }
        }
    }

    private void createActions() {
        this.actionStartServer = (DockingAction)((ActionBuilder)((ActionBuilder)StartServerAction.builder(this.plugin).enabledWhen(this::isActionStartServerEnabled)).onAction(this::doActionStartServerActivated)).buildAndInstallLocal((ComponentProvider)this);
        this.actionStopServer = (DockingAction)((ActionBuilder)((ActionBuilder)StopServerAction.builder(this.plugin).enabledWhen(this::isActionStopServerEnabled)).onAction(this::doActionStopServerActivated)).buildAndInstallLocal((ComponentProvider)this);
        this.actionConnectAccept = (DockingAction)((ActionBuilder)((ActionBuilder)ConnectAcceptAction.builder(this.plugin).enabledWhen(this::isActionConnectAcceptEnabled)).onAction(this::doActionConnectAcceptActivated)).buildAndInstallLocal((ComponentProvider)this);
        this.actionConnectOutbound = (DockingAction)((ActionBuilder)((ActionBuilder)ConnectOutboundAction.builder(this.plugin).enabledWhen(this::isActionConnectOutboundEnabled)).onAction(this::doActionConnectOutboundActivated)).buildAndInstallLocal((ComponentProvider)this);
        this.actionCloseConnection = (DockingAction)CloseConnectionAction.builder(this.plugin).withContext(TraceRmiManagerActionContext.class).enabledWhen(this::isActionCloseConnectionEnabled).onAction(this::doActionCloseConnectionActivated).buildAndInstallLocal((ComponentProvider)this);
        this.actionCloseAll = (DockingAction)((ActionBuilder)((ActionBuilder)CloseAllAction.builder(this.plugin).enabledWhen(this::isActionCloseAllEnabled)).onAction(this::doActionCloseAllActivated)).buildAndInstallLocal((ComponentProvider)this);
        this.actionForceCloseTransactions = (DockingAction)ForceCloseTransactionsActions.builder(this.plugin).withContext(TraceRmiManagerActionContext.class).enabledWhen(this::isActionForceCloseTransactionsEnabled).onAction(this::doActionCloseTransactionsActivated).buildAndInstallLocal((ComponentProvider)this);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void setContext() {
        this.myActionContext = new TraceRmiManagerActionContext(this, this.tree.getSelectionPath(), this.tree);
        this.contextChanged();
    }

    private boolean isActionStartServerEnabled(ActionContext __) {
        return this.traceRmiService != null && !this.traceRmiService.isServerStarted();
    }

    private InetSocketAddress promptSocketAddress(String title, String okText, HelpLocation helpLocation) {
        TraceRmiConnectDialog dialog = new TraceRmiConnectDialog(this.tool, title, okText);
        dialog.setHelpLocation(helpLocation);
        Map<String, ValStr<?>> arguments = dialog.promptArguments();
        if (arguments == null) {
            return null;
        }
        String address = (String)TraceRmiConnectDialog.PARAM_ADDRESS.get(arguments).val();
        int port = (Integer)TraceRmiConnectDialog.PARAM_PORT.get(arguments).val();
        return new InetSocketAddress(address, port);
    }

    private void doActionStartServerActivated(ActionContext __) {
        InetSocketAddress sockaddr = this.promptSocketAddress("Start Trace RMI Server", "Start", this.actionStartServer.getHelpLocation());
        if (sockaddr == null) {
            return;
        }
        try {
            this.traceRmiService.setServerAddress((SocketAddress)sockaddr);
            this.traceRmiService.startServer();
            if (this.consoleService != null) {
                this.consoleService.log(DebuggerResources.ICON_CONNECTION, "TraceRmi Server listening at " + String.valueOf(this.traceRmiService.getServerAddress()));
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Could not start TraceRmi server: " + String.valueOf(e)));
        }
    }

    private boolean isActionStopServerEnabled(ActionContext __) {
        return this.traceRmiService != null && this.traceRmiService.isServerStarted();
    }

    private void doActionStopServerActivated(ActionContext __) {
        this.traceRmiService.stopServer();
        if (this.consoleService != null) {
            this.consoleService.log(DebuggerResources.ICON_DISCONNECT, "TraceRmi Server stopped");
        }
    }

    private boolean isActionConnectAcceptEnabled(ActionContext __) {
        return this.traceRmiService != null;
    }

    private void doActionConnectAcceptActivated(ActionContext __) {
        InetSocketAddress sockaddr = this.promptSocketAddress("Accept Trace RMI Connection", "Listen", this.actionConnectAccept.getHelpLocation());
        if (sockaddr == null) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                TraceRmiAcceptor acceptor = this.traceRmiService.acceptOne((SocketAddress)sockaddr);
                acceptor.accept();
            }
            catch (CancelledException acceptor) {
            }
            catch (Throwable e) {
                Msg.showError((Object)((Object)this), null, (String)"Accept", (Object)("Could not accept Trace RMI Connection on " + String.valueOf(sockaddr) + ": " + String.valueOf(e)));
            }
        });
    }

    private boolean isActionConnectOutboundEnabled(ActionContext __) {
        return this.traceRmiService != null;
    }

    private void doActionConnectOutboundActivated(ActionContext __) {
        InetSocketAddress sockaddr = this.promptSocketAddress("Connect to Trace RMI", "Connect", this.actionConnectOutbound.getHelpLocation());
        if (sockaddr == null) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.traceRmiService.connect((SocketAddress)sockaddr);
            }
            catch (Throwable e) {
                Msg.showError((Object)((Object)this), null, (String)"Connect", (Object)("Could connect to Trace RMI at " + String.valueOf(sockaddr) + ": " + e.getMessage()));
            }
        });
    }

    private boolean isActionCloseConnectionEnabled(TraceRmiManagerActionContext context) {
        TraceRmiManagerNode node = context.getSelectedNode();
        if (node instanceof TraceRmiConnectionNode) {
            return true;
        }
        return node instanceof TraceRmiAcceptorNode;
    }

    private void doActionCloseConnectionActivated(TraceRmiManagerActionContext context) {
        TraceRmiManagerNode node = context.getSelectedNode();
        if (node instanceof TraceRmiConnectionNode) {
            TraceRmiConnectionNode cxNode = (TraceRmiConnectionNode)node;
            try {
                cxNode.getConnection().close();
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Close Connection", (Object)("Could not close Trace RMI connection: " + String.valueOf(e)));
            }
        } else if (node instanceof TraceRmiAcceptorNode) {
            TraceRmiAcceptorNode acNode = (TraceRmiAcceptorNode)node;
            acNode.getAcceptor().cancel();
        }
    }

    private boolean isActionCloseAllEnabled(ActionContext __) {
        return this.traceRmiService != null;
    }

    private void doActionCloseAllActivated(ActionContext __) {
        try {
            this.doActionStopServerActivated(__);
        }
        catch (Throwable e) {
            Msg.error((Object)((Object)this), (Object)("Could not close server: " + String.valueOf(e)));
        }
        for (TraceRmiConnection connection : this.traceRmiService.getAllConnections()) {
            try {
                connection.close();
            }
            catch (Throwable e) {
                Msg.error((Object)((Object)this), (Object)("Could not close " + String.valueOf(connection) + ": " + String.valueOf(e)));
            }
        }
        for (TraceRmiAcceptor acceptor : this.traceRmiService.getAllAcceptors()) {
            try {
                acceptor.cancel();
            }
            catch (Throwable e) {
                Msg.error((Object)((Object)this), (Object)("Could not cancel " + String.valueOf(acceptor) + ": " + String.valueOf(e)));
            }
        }
    }

    private boolean isActionForceCloseTransactionsEnabled(TraceRmiManagerActionContext context) {
        TraceRmiManagerNode node = context.getSelectedNode();
        return node instanceof TraceRmiTargetNode;
    }

    private void doActionCloseTransactionsActivated(TraceRmiManagerActionContext context) {
        TraceRmiManagerNode node = context.getSelectedNode();
        if (node instanceof TraceRmiTargetNode) {
            TraceRmiTargetNode tNode = (TraceRmiTargetNode)node;
            tNode.getTarget().forciblyCloseTransactions();
        }
    }

    @AutoServiceConsumed
    private void setTraceRmiService(TraceRmiService traceRmiService) {
        if (this.traceRmiService != null) {
            this.traceRmiService.removeTraceServiceListener((TraceRmiServiceListener)this.rootNode);
        }
        this.traceRmiService = traceRmiService;
        if (this.traceRmiService != null) {
            this.traceRmiService.addTraceServiceListener((TraceRmiServiceListener)this.rootNode);
        }
    }

    @AutoServiceConsumed
    private void setTargetService(DebuggerTargetService targetService) {
        if (this.targetService != null) {
            this.targetService.removeTargetPublicationListener((TargetPublicationListener)this.rootNode);
        }
        this.targetService = targetService;
        if (this.targetService != null) {
            this.targetService.addTargetPublicationListener((TargetPublicationListener)this.rootNode);
        }
    }

    public TraceRmiService getTraceRmiService() {
        return this.traceRmiService;
    }

    public void coordinates(DebuggerCoordinates coordinates) {
        if (this.rootNode == null) {
            return;
        }
        this.rootNode.coordinates(coordinates);
    }

    class InjectableGTree
    extends GTree {
        public InjectableGTree(GTreeNode root) {
            super(root);
        }

        protected void processEvent(AWTEvent e) {
            super.processEvent(e);
        }
    }

    static interface StartServerAction {
        public static final String NAME = "Start Server";
        public static final String DESCRIPTION = "Start a TCP server for incoming connections (indefinitely)";
        public static final String GROUP = "2. Server";
        public static final String HELP_ANCHOR = "start_server";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("2. Server")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface StopServerAction {
        public static final String NAME = "Stop Server";
        public static final String DESCRIPTION = "Close the TCP server";
        public static final String GROUP = "2. Server";
        public static final String HELP_ANCHOR = "stop_server";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("2. Server")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ConnectAcceptAction {
        public static final String NAME = "Connect by Accept";
        public static final String DESCRIPTION = "Accept a single inbound TCP connection";
        public static final String GROUP = "1. Connect";
        public static final Icon ICON = DebuggerResources.ICON_CONNECT_ACCEPT;
        public static final String HELP_ANCHOR = "connect_accept";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("1. Connect")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ConnectOutboundAction {
        public static final String NAME = "Connect Outbound";
        public static final String DESCRIPTION = "Connect to a listening agent/plugin by TCP";
        public static final String GROUP = "1. Connect";
        public static final Icon ICON = DebuggerResources.ICON_CONNECT_OUTBOUND;
        public static final String HELP_ANCHOR = "connect_outbound";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("1. Connect")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface CloseConnectionAction {
        public static final String NAME = "\u5173\u95ed";
        public static final String DESCRIPTION = "Close a connection or server";
        public static final String GROUP = "3. Maintenance";
        public static final String HELP_ANCHOR = "close";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).popupMenuPath(new String[]{NAME})).menuGroup("3. Maintenance")).popupMenuGroup("3. Maintenance")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface CloseAllAction {
        public static final String NAME = "\u5173\u95ed\u5168\u90e8";
        public static final String DESCRIPTION = "Close all connections and the server";
        public static final String GROUP = "3. Maintenance";
        public static final String HELP_ANCHOR = "close_all";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup("3. Maintenance")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ForceCloseTransactionsActions {
        public static final String NAME = "Forcibly Close Transactions";
        public static final String DESCRIPTION = "Forcibly commit all remote transactions on the trace";
        public static final String GROUP = "3. Maintenance";
        public static final String HELP_ANCHOR = "forcibly_close_txes";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).popupMenuPath(new String[]{NAME})).menuGroup("3. Maintenance")).popupMenuGroup("3. Maintenance")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

