/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.sys.EmuSyscallLibrary;
import ghidra.pcode.emu.sys.EmuSystemException;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import java.util.Arrays;
import java.util.List;

public class UseropEmuSyscallDefinition<T>
implements EmuSyscallLibrary.EmuSyscallDefinition<T> {
    protected final PcodeOp op;
    protected final PcodeUseropLibrary.PcodeUseropDefinition<T> opdef;
    protected final List<Varnode> inVars;
    protected final Varnode outVar;

    protected static DataType requirePointerDataType(Program program) {
        DataType dtPointer = program.getDataTypeManager().getDataType("/pointer");
        if (dtPointer == null) {
            throw new IllegalArgumentException("No 'pointer' data type in " + String.valueOf(program));
        }
        return dtPointer;
    }

    public UseropEmuSyscallDefinition(long number, PcodeUseropLibrary.PcodeUseropDefinition<T> opdef, Program program, PrototypeModel convention, DataType dtMachineWord) {
        this.opdef = opdef;
        int inputCount = opdef.getInputCount();
        if (inputCount < 0) {
            throw new IllegalArgumentException("Variadic sleigh userop " + opdef.getName() + " cannot be used as a syscall");
        }
        DataType[] locs = new DataType[inputCount + 1];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = dtMachineWord;
        }
        VariableStorage[] vss = convention.getStorageLocations(program, locs, false);
        this.outVar = this.getSingleVnStorage(vss[0]);
        this.inVars = Arrays.asList(new Varnode[inputCount]);
        Varnode[] opIns = new Varnode[inputCount + 1];
        opIns[0] = new Varnode(program.getAddressFactory().getConstantAddress(number), 4);
        for (int i = 0; i < inputCount; ++i) {
            Varnode vnIn = this.getSingleVnStorage(vss[i + 1]);
            this.inVars.set(i, vnIn);
            opIns[i + 1] = vnIn;
        }
        this.op = new PcodeOp(new SequenceNumber(Address.NO_ADDRESS, 0), 9, opIns, this.outVar);
    }

    protected Varnode getSingleVnStorage(VariableStorage vs) {
        Varnode[] vns = vs.getVarnodes();
        if (vns.length != 1) {
            Unfinished.TODO();
        }
        return vns[0];
    }

    @Override
    public void invoke(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library) {
        try {
            this.opdef.execute(executor, library, this.op, this.outVar, this.inVars);
        }
        catch (PcodeExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EmuSystemException("Error during syscall", null, e);
        }
    }
}

