/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.sys.EmuSyscallLibrary;
import ghidra.pcode.emu.sys.UseropEmuSyscallDefinition;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import utilities.util.AnnotationUtilities;

public abstract class AnnotatedEmuSyscallUseropLibrary<T>
extends AnnotatedPcodeUseropLibrary<T>
implements EmuSyscallLibrary<T> {
    public static final String SYSCALL_SPACE_NAME = "syscall";
    protected static final Map<Class<?>, Set<Method>> CACHE_BY_CLASS = new HashMap();
    private final EmuSyscallLibrary.SyscallPcodeUseropDefinition<T> syscallUserop = new EmuSyscallLibrary.SyscallPcodeUseropDefinition(this);
    protected final PcodeMachine<T> machine;
    protected final CompilerSpec cSpec;
    protected final Program program;
    protected final DataType dtMachineWord;
    protected final Map<Long, EmuSyscallLibrary.EmuSyscallDefinition<T>> syscallMap = new HashMap<Long, EmuSyscallLibrary.EmuSyscallDefinition<T>>();
    protected final Collection<DataTypeManager> additionalArchives;

    private static Set<Method> collectSyscalls(Class<?> cls) {
        return AnnotationUtilities.collectAnnotatedMethods(EmuSyscall.class, cls);
    }

    public AnnotatedEmuSyscallUseropLibrary(PcodeMachine<T> machine, Program program) {
        this.machine = machine;
        this.program = program;
        this.cSpec = program.getCompilerSpec();
        this.dtMachineWord = UseropEmuSyscallDefinition.requirePointerDataType(program);
        this.mapAndBindSyscalls();
        this.additionalArchives = this.getAdditionalArchives();
        StructuredPart structured = this.newStructuredPart();
        structured.generate(this.ops);
        this.disposeAdditionalArchives();
        this.mapAndBindSyscalls(structured.getClass());
    }

    protected Collection<DataTypeManager> getAdditionalArchives() {
        return List.of();
    }

    protected void disposeAdditionalArchives() {
    }

    protected StructuredPart newStructuredPart() {
        return new StructuredPart(this);
    }

    public UseropEmuSyscallDefinition<T> newBoundSyscall(long number, PcodeUseropLibrary.PcodeUseropDefinition<T> opdef, PrototypeModel convention) {
        return new UseropEmuSyscallDefinition<T>(number, opdef, this.program, convention, this.dtMachineWord);
    }

    protected void mapAndBindSyscalls(Class<?> cls) {
        DualHashBidiMap mapNames = new DualHashBidiMap(EmuSyscallLibrary.loadSyscallNumberMap(this.program));
        Map<Long, PrototypeModel> mapConventions = EmuSyscallLibrary.loadSyscallConventionMap(this.program);
        Set<Method> methods = AnnotatedEmuSyscallUseropLibrary.collectSyscalls(cls);
        for (Method m : methods) {
            String name = m.getAnnotation(EmuSyscall.class).value();
            Long number = (Long)mapNames.getKey((Object)name);
            if (number == null) {
                Msg.warn(cls, (Object)("Syscall " + name + " has no number"));
                continue;
            }
            PcodeUseropLibrary.PcodeUseropDefinition opdef = (PcodeUseropLibrary.PcodeUseropDefinition)this.getUserops().get(m.getName());
            if (opdef == null) {
                throw new IllegalArgumentException("Method " + m.getName() + " annotated with @" + EmuSyscall.class.getSimpleName() + " must also be a p-code userop");
            }
            PrototypeModel convention = mapConventions.get(number);
            EmuSyscallLibrary.EmuSyscallDefinition existed = this.syscallMap.put(number, this.newBoundSyscall(number, opdef, convention));
            if (existed == null) continue;
            throw new IllegalArgumentException("Duplicate @" + EmuSyscall.class.getSimpleName() + " annotated methods with name " + name);
        }
    }

    protected void mapAndBindSyscalls() {
        this.mapAndBindSyscalls(this.getClass());
    }

    @Override
    public PcodeUseropLibrary.PcodeUseropDefinition<T> getSyscallUserop() {
        return this.syscallUserop;
    }

    @Override
    public Map<Long, EmuSyscallLibrary.EmuSyscallDefinition<T>> getSyscalls() {
        return this.syscallMap;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface EmuSyscall {
        public String value();
    }

    protected class StructuredPart
    extends StructuredSleigh {
        protected StructuredPart(AnnotatedEmuSyscallUseropLibrary this$0) {
            super(this$0.program);
            this.addDataTypeSources(this$0.additionalArchives);
        }
    }
}

