/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.charset.CharsetInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CharsetInfoManager {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF32 = "UTF-32";
    public static final String USASCII = "US-ASCII";
    public static Comparator<String> CHARSET_NAME_COMP = (s1, s2) -> CharsetInfoManager.stripCharsetX(s1).compareToIgnoreCase(CharsetInfoManager.stripCharsetX(s2));
    public static Comparator<CharsetInfo> CHARSET_COMP = (csi1, csi2) -> CharsetInfoManager.stripCharsetX(csi1.getName()).compareToIgnoreCase(CharsetInfoManager.stripCharsetX(csi2.getName()));
    private Map<String, CharsetInfo> charsets = new LinkedHashMap<String, CharsetInfo>();

    public static CharsetInfoManager getInstance() {
        return Singleton.INSTANCE;
    }

    public static boolean isBOMCharset(String charsetName) {
        return UTF32.equals(charsetName) || UTF16.equals(charsetName);
    }

    private static String stripCharsetX(String csName) {
        return csName.startsWith("x-") ? csName.substring(2) : csName;
    }

    private CharsetInfoManager() {
        this(List.of());
    }

    private CharsetInfoManager(List<CharsetInfo> userDefinedInfo) {
        CharsetInfoManager.getStandardCharsets().forEach(csi -> this.charsets.put(csi.getName(), (CharsetInfo)csi));
        userDefinedInfo.forEach(csi -> {
            if (Charset.isSupported(csi.getName())) {
                this.charsets.put(csi.getName(), (CharsetInfo)csi);
            }
        });
        ArrayList<String> availCSNames = new ArrayList<String>(Charset.availableCharsets().keySet());
        availCSNames.sort(CHARSET_NAME_COMP);
        for (String csName : availCSNames) {
            if (this.charsets.containsKey(csName)) continue;
            this.charsets.put(csName, new CharsetInfo(Charset.forName(csName)));
        }
    }

    public List<String> getCharsetNames() {
        return List.copyOf(this.charsets.keySet());
    }

    public List<CharsetInfo> getCharsets() {
        return List.copyOf(this.charsets.values());
    }

    public int getCharsetCharSize(String charsetName) {
        CharsetInfo csi = this.charsets.get(charsetName);
        return csi != null ? csi.getMinBytesPerChar() : 1;
    }

    public List<String> getCharsetNamesWithCharSize(int size) {
        return this.charsets.values().stream().filter(csi -> csi.getMinBytesPerChar() == size).map(csi -> csi.getName()).toList();
    }

    public CharsetInfo get(Charset cs) {
        return this.charsets.get(cs.name());
    }

    public CharsetInfo get(String name) {
        return this.charsets.get(name);
    }

    public CharsetInfo get(String name, Charset defaultCS) {
        CharsetInfo result = this.charsets.get(name);
        if (result == null && defaultCS != null) {
            result = this.charsets.get(defaultCS.name());
        }
        return result;
    }

    public List<Character.UnicodeScript> getMostImplementedScripts() {
        EnumSet<Character.UnicodeScript> scriptsToIgnore = EnumSet.of(Character.UnicodeScript.COMMON, Character.UnicodeScript.INHERITED, Character.UnicodeScript.UNKNOWN, Character.UnicodeScript.LATIN, Character.UnicodeScript.GREEK);
        List<Character.UnicodeScript> scripts = this.charsets.values().stream().filter(csi -> !csi.supportsAllScripts()).flatMap(csi -> csi.getScripts().stream()).filter(script -> !scriptsToIgnore.contains(script)).sorted((o1, o2) -> o1.name().compareTo(o2.name())).distinct().toList();
        return scripts;
    }

    public static List<String> getStandardCharsetNames() {
        return List.of(USASCII, UTF8, UTF16, UTF32);
    }

    private static List<CharsetInfo> getStandardCharsets() {
        return List.of(new CharsetInfo(USASCII, null, 1, 1, 1, -1, true, true, EnumSet.of(Character.UnicodeScript.COMMON, Character.UnicodeScript.LATIN), Set.of()), new CharsetInfo(UTF8, null, 1, 4, 1, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(UTF16, null, 2, 4, 2, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(StandardCharsets.UTF_16BE.name(), null, 2, 4, 2, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(StandardCharsets.UTF_16LE.name(), null, 2, 4, 2, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(CharSetsSingleton.UTF_32.name(), null, 4, 4, 4, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(CharSetsSingleton.UTF_32BE.name(), null, 4, 4, 4, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(CharSetsSingleton.UTF_32LE.name(), null, 4, 4, 4, -1, true, true, CharsetInfo.ALL_SCRIPTS, Set.of()), new CharsetInfo(StandardCharsets.ISO_8859_1.name(), null, 1, 1, 1, -1, true, false, EnumSet.of(Character.UnicodeScript.COMMON, Character.UnicodeScript.LATIN), Set.of(USASCII)));
    }

    public static void reinitializeWithUserDefinedCharsets() {
        CharsetInfoConfigFile configFile = CharsetInfoConfigFile.read(CharsetInfoManager.getConfigFileLocation());
        if (!configFile.getCharsets().isEmpty()) {
            Singleton.INSTANCE = new CharsetInfoManager(configFile.getCharsets());
        }
    }

    public static ResourceFile getConfigFileLocation() {
        return Application.findDataFileInAnyModule((String)"charset_info.json");
    }

    private static final class Singleton {
        private static CharsetInfoManager INSTANCE = new CharsetInfoManager();

        private Singleton() {
        }
    }

    private static final class CharSetsSingleton {
        private static final Charset UTF_32 = Charset.forName("UTF-32");
        private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
        private static final Charset UTF_32BE = Charset.forName("UTF-32BE");

        private CharSetsSingleton() {
        }
    }

    public static class CharsetInfoConfigFile {
        private List<String> comments;
        private List<CharsetInfo> charsets;

        /*
         * Enabled aggressive exception aggregation
         */
        public static CharsetInfoConfigFile read(ResourceFile configFile) {
            if (configFile != null) {
                try (InputStream is = configFile.getInputStream();){
                    CharsetInfoConfigFile configFileData;
                    JsonReader reader;
                    block16: {
                        CharsetInfoConfigFile charsetInfoConfigFile;
                        reader = new JsonReader((Reader)new InputStreamReader(is));
                        try {
                            Gson gson = new GsonBuilder().create();
                            configFileData = (CharsetInfoConfigFile)gson.fromJson(reader, CharsetInfoConfigFile.class);
                            if (configFileData != null) break block16;
                            charsetInfoConfigFile = new CharsetInfoConfigFile();
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        reader.close();
                        return charsetInfoConfigFile;
                    }
                    configFileData.validateData();
                    CharsetInfoConfigFile charsetInfoConfigFile = configFileData;
                    reader.close();
                    return charsetInfoConfigFile;
                }
                catch (JsonParseException | IOException e) {
                    Msg.error(CharsetInfoManager.class, (Object)"Error reading charset_info.json", (Throwable)e);
                }
            }
            return new CharsetInfoConfigFile();
        }

        public CharsetInfoConfigFile() {
            this.comments = List.of();
            this.charsets = List.of();
        }

        public CharsetInfoConfigFile(String comment, List<CharsetInfo> charsets) {
            this.comments = comment.lines().toList();
            this.charsets = charsets;
        }

        public String getComment() {
            return String.join((CharSequence)"\n", this.comments);
        }

        public List<CharsetInfo> getCharsets() {
            return this.charsets;
        }

        public void validateData() {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> dups = new HashSet<String>();
            HashSet<String> unknowns = new HashSet<String>();
            for (CharsetInfo csi : this.charsets) {
                if (!names.add(csi.getName())) {
                    dups.add(csi.getName());
                }
                if (Charset.isSupported(csi.getName())) continue;
                unknowns.add(csi.getName());
            }
            if (!dups.isEmpty()) {
                Msg.warn(CharsetInfoManager.class, (Object)("Duplicate charset names found in charset_info.json: " + String.valueOf(dups)));
            }
            if (!unknowns.isEmpty()) {
                Msg.warn(CharsetInfoManager.class, (Object)("Unknown/unsupported charset names found in charset_info.json: " + String.valueOf(unknowns)));
            }
        }

        public void write(File configFilename) throws IOException {
            File configDir = configFilename.getParentFile();
            File tmpConfigFile = new File(configDir, configFilename.getName() + ".tmp");
            File prevConfigFile = new File(configDir, configFilename.getName() + ".prev");
            try (FileWriter fw = new FileWriter(tmpConfigFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy(new ExclusionStrategy(this){

                    public boolean shouldSkipField(FieldAttributes f) {
                        return f.getDeclaringClass().equals(CharsetInfo.class) && CharsetInfo.FIELDS_TO_EXCLUDE_FROM_JSON.contains(f.getName());
                    }

                    public boolean shouldSkipClass(Class<?> clazz) {
                        return false;
                    }
                }).create();
                gson.toJson((Object)this, (Appendable)fw);
            }
            prevConfigFile.delete();
            configFilename.renameTo(prevConfigFile);
            if (tmpConfigFile.renameTo(configFilename)) {
                prevConfigFile.delete();
            }
        }
    }
}

