/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class IntegerFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 11;

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public int getUnitByteSize() {
        return 4;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        int i = block.getInt(index);
        return DataFormatModel.pad(Integer.toString(i), this.symbolSize, " ");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Integer");
    }
}

