/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.MutableDataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public abstract class HexValueFormatModel
implements UniversalDataFormatModel,
MutableDataFormatModel {
    protected final String name;
    protected final int symbolSize;
    protected final int nbytes;
    protected final String fullSymbolErrorStr;

    public HexValueFormatModel(String name, int nbytes) {
        this.name = name;
        this.nbytes = nbytes;
        this.symbolSize = nbytes * 2;
        this.fullSymbolErrorStr = "??".repeat(nbytes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getUnitByteSize() {
        return this.nbytes;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        int o = position / 2;
        if (block.isBigEndian()) {
            return o;
        }
        return this.nbytes - 1 - o;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        if (byteOffset > this.nbytes - 1) {
            throw new IllegalArgumentException("invalid byteOffset: " + byteOffset);
        }
        if (block.isBigEndian()) {
            return byteOffset * 2;
        }
        return (this.nbytes - 1 - byteOffset) * 2;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public abstract String getDataRepresentation(ByteBlock var1, BigInteger var2) throws ByteBlockAccessException;

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition < 0 || charPosition > this.symbolSize - 1) {
            return false;
        }
        char[] charArray = new char[]{c};
        byte cb = Byte.parseByte(new String(charArray), 16);
        int byteOffset = this.getByteOffset(block, charPosition);
        index = index.add(BigInteger.valueOf(byteOffset));
        byte b = block.getByte(index);
        b = this.adjustByte(b, cb, charPosition);
        block.setByte(index, b);
        return true;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    private byte adjustByte(byte b, byte newb, int charPosition) {
        if (charPosition % 2 == 0) {
            b = (byte)(b & 0xF);
            newb = (byte)(newb << 4);
        } else {
            b = (byte)(b & 0xF0);
        }
        b = (byte)(b + newb);
        return b;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", this.name.replaceAll(" ", ""));
    }
}

