/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.MutableDataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class HexFormatModel
implements UniversalDataFormatModel,
MutableDataFormatModel {
    public static final String NAME = "Hex";
    private int symbolSize = 2;
    private int groupSize = 1;
    private String fullSymbolErrorStr = "??";
    private static final String GOOD_CHARS = "0123456789abcdefABCDEF";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getUnitByteSize() {
        return this.groupSize;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setByteViewerConfigOptions(ByteViewerConfigOptions options) {
        this.groupSize = options.getHexGroupSize();
        this.symbolSize = 2 * this.groupSize;
        this.fullSymbolErrorStr = "??".repeat(this.groupSize);
    }

    @Override
    public String validateByteViewerConfigOptions(ByteViewerConfigOptions candidateOptions) {
        if (candidateOptions.getBytesPerLine() % candidateOptions.getHexGroupSize() != 0) {
            return "Hex (%d bytes) is not a multiple of %d".formatted(candidateOptions.getHexGroupSize(), candidateOptions.getBytesPerLine());
        }
        return null;
    }

    public int getHexGroupSize() {
        return this.groupSize;
    }

    @Override
    public int getByteOffset(ByteBlock block, int pos) {
        return pos < this.symbolSize ? pos / 2 : this.groupSize - 1;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return byteOffset * 2;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        byte[] bytes = new byte[this.groupSize];
        int bytesRead = block.getBytes(bytes, index, this.groupSize);
        if (bytesRead == 0) {
            return this.fullSymbolErrorStr;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytesRead; ++i) {
            sb.append("%02x".formatted(Byte.toUnsignedInt(bytes[i])));
        }
        return sb.toString();
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (GOOD_CHARS.indexOf(c) == -1) {
            return false;
        }
        if (charPosition < 0 || charPosition >= this.symbolSize) {
            return false;
        }
        int byteNo = this.getByteOffset(block, charPosition);
        index = index.add(BigInteger.valueOf(byteNo));
        byte b = block.getByte(index);
        char[] charArray = new char[]{c};
        byte cb = Byte.parseByte(new String(charArray), 16);
        if (charPosition % 2 == 0) {
            b = (byte)(b & 0xF);
            cb = (byte)(cb << 4);
            b = (byte)(b + cb);
        } else {
            b = (byte)(b & 0xF0);
            b = (byte)(b + cb);
        }
        block.setByte(index, b);
        return true;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", NAME);
    }
}

