/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ProgramDataFormatModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class DisassembledFormatModel
implements ProgramDataFormatModel {
    public static final String BLOCK = "\u25a1";
    private int symbolSize = 1;
    private Program program;
    private Listing listing;

    @Override
    public String getName() {
        return "Disassembled";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        String addrStr = block.getLocationRepresentation(index);
        String str = null;
        if (this.listing != null) {
            Address a = null;
            if (addrStr != null) {
                a = this.program.getAddressFactory().getAddress(addrStr);
            }
            str = a == null ? "?" : (this.listing.getInstructionContaining(a) != null || this.listing.getDefinedDataContaining(a) != null ? "." : BLOCK);
        } else {
            str = "?";
        }
        return str;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public void setProgram(Program program) {
        this.program = program;
        this.listing = program == null ? null : this.program.getListing();
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Disassembled");
    }

    @Override
    public void dispose() {
        this.listing = null;
        this.program = null;
    }
}

