/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ExtensionPoint;
import java.math.BigInteger;

public interface DataFormatModel
extends ExtensionPoint {
    public int getUnitByteSize();

    public String getName();

    default public String getDescriptiveName() {
        return this.getName();
    }

    public HelpLocation getHelpLocation();

    public int getDataUnitSymbolSize();

    public int getByteOffset(ByteBlock var1, int var2);

    public int getColumnPosition(ByteBlock var1, int var2);

    public String getDataRepresentation(ByteBlock var1, BigInteger var2) throws ByteBlockAccessException;

    default public void setByteViewerConfigOptions(ByteViewerConfigOptions options) {
    }

    default public String validateByteViewerConfigOptions(ByteViewerConfigOptions candidateOptions) {
        return null;
    }

    public int getUnitDelimiterSize();

    default public void dispose() {
    }

    public static String pad(String value, int symbolSize) {
        return DataFormatModel.pad(value, symbolSize, "0");
    }

    public static String pad(String value, int symbolSize, String padChar) {
        return padChar.repeat(Math.max(symbolSize - value.length(), 0)) + value;
    }
}

