/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.builder.ToggleActionBuilder;
import docking.actions.PopupActionProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerActionContext;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.CursorWidthDataFormatModel;
import ghidra.app.plugin.core.format.MutableDataFormatModel;
import ghidra.app.plugin.core.format.TooltipDataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.program.model.lang.Endian;
import ghidra.util.HelpLocation;
import ghidra.util.NumericUtilities;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.CharsetInfoManager;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class CharacterFormatModel
implements UniversalDataFormatModel,
MutableDataFormatModel,
PopupActionProvider,
CursorWidthDataFormatModel,
TooltipDataFormatModel {
    public static final String NAME = "Chars";
    private CharsetInfo csi = CharsetInfoManager.getInstance().get(StandardCharsets.US_ASCII);
    private Charset cs = StandardCharsets.US_ASCII;
    private int maxBytesPerChar = 1;
    private boolean compactChars = true;
    private int bytesPerChar = 1;

    @Override
    public void setByteViewerConfigOptions(ByteViewerConfigOptions options) {
        this.csi = options.getCharsetInfo();
        this.cs = this.csi.getCharset();
        this.maxBytesPerChar = Math.max(this.csi.getMaxBytesPerChar(), 1);
        this.compactChars = options.isCompactChars();
        this.bytesPerChar = options.isUseCharAlignment() && this.csi.getAlignment() > 1 ? this.csi.getAlignment() : 1;
    }

    @Override
    public int getCursorWidth(FontMetrics fm) {
        return fm.charWidth('W') * (this.compactChars ? 1 : 2);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescriptiveName() {
        return NAME + " (%s)".formatted(this.cs.name());
    }

    @Override
    public int getUnitByteSize() {
        return this.bytesPerChar;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return 1;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        Integer codePoint = this.getCodePointAt(block, index);
        if (codePoint == null) {
            return "?";
        }
        int cp = codePoint;
        if (cp == 65533 || Character.isISOControl(cp) || !Character.isValidCodePoint(cp)) {
            return ".";
        }
        return Character.toString(cp);
    }

    private Integer getCodePointAt(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        Charset bomCS = this.getAdjustedCS(block);
        byte[] bytes = new byte[this.maxBytesPerChar];
        int byteCount = block.getBytes(bytes, index, this.maxBytesPerChar);
        String s = new String(bytes, 0, byteCount, bomCS);
        if (s.isEmpty()) {
            return null;
        }
        return s.codePointAt(0);
    }

    private Charset getAdjustedCS(ByteBlock block) {
        if (CharsetInfoManager.isBOMCharset((String)this.csi.getName())) {
            Endian endian = block.isBigEndian() ? Endian.BIG : Endian.LITTLE;
            CharsetInfo bomCSI = CharsetInfoManager.getInstance().get(this.csi.getName() + endian.toShortString());
            return bomCSI != null ? bomCSI.getCharset() : this.cs;
        }
        return this.cs;
    }

    private byte[] getBytesForCodePoint(int cp, Charset bomCS) {
        String s = Character.toString(cp);
        if (bomCS.canEncode() && bomCS.newEncoder().canEncode(s)) {
            ByteBuffer bb = bomCS.encode(s);
            byte[] bytes = new byte[bb.limit()];
            bb.get(bytes);
            return bytes;
        }
        return null;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition != 0) {
            return false;
        }
        block.getByte(index);
        byte cb = (byte)c;
        if (cb < 32 || cb == 127) {
            return false;
        }
        block.setByte(index, cb);
        return true;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", NAME);
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        return List.of(new ToggleActionBuilder("CompactCharWidth", "ByteViewerPlugin").selected(this.compactChars).withContext(ByteViewerActionContext.class).popupMenuPath(new String[]{"Compact/Wide Layout"}).onAction(ac -> ac.getComponentProvider().setCompactChars(!this.compactChars)).helpLocation(new HelpLocation("ByteViewerPlugin", "CompactCharWidth")).build());
    }

    @Override
    public String getTooltip(ByteBlock block, BigInteger index, ByteViewerComponent comp) {
        try {
            Integer cp = this.getCodePointAt(block, index);
            if (cp != null) {
                Charset bomCS = this.getAdjustedCS(block);
                byte[] bytes = this.getBytesForCodePoint(cp, bomCS);
                boolean canDisplay = comp.getFont().canDisplay(cp);
                Character.UnicodeScript script = Character.UnicodeScript.of(cp);
                String charRep = canDisplay && !Character.isISOControl(cp) ? Character.toString(cp) : "NA";
                String bytesRep = bytes != null ? NumericUtilities.convertBytesToString((byte[])bytes, (String)" ") : "unavailable";
                String s = "<html>\n<b>Character info:</b><br>\n<table>\n<tr><td>Char</td><td>Unicode</td><td>Script</td></tr>\n<tr><b>%s</b></td><td>0x%04x</td><td>%s</td></tr>\n</table>\n<hr>\n<br>\n%s Bytes: <b>%s</b><br>\n%s\n<br>\n".formatted(new Object[]{charRep, cp, script, bomCS.name(), bytesRep, !canDisplay ? "<br>(unrenderable)" : ""});
                return s;
            }
        }
        catch (ByteBlockAccessException byteBlockAccessException) {
            // empty catch block
        }
        return null;
    }
}

