/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.MemoryByteBlock;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ProgramDataFormatModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class AddressFormatModel
implements ProgramDataFormatModel {
    public static final String GOOD_ADDRESS = "\u278a";
    public static final String BAD_ADDRESS = ".";
    public static final String NON_ADDRESS = "?";
    private int symbolSize = 1;
    private Listing listing;
    private Memory memory;

    @Override
    public String getName() {
        return "Address";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        String str = NON_ADDRESS;
        if (this.listing != null && block instanceof MemoryByteBlock) {
            str = BAD_ADDRESS;
            MemoryByteBlock memBlock = (MemoryByteBlock)block;
            Address a = memBlock.getAddress(index);
            Address testAddress = this.getTestAddress(a);
            if (testAddress != null && this.memory.contains(testAddress)) {
                str = GOOD_ADDRESS;
            }
        }
        return str;
    }

    private Address getTestAddress(Address a) {
        int size = a.getAddressSpace().getSize();
        int nbytes = size / 8;
        try {
            long value = 0L;
            switch (nbytes) {
                case 8: {
                    value = this.memory.getLong(a);
                    break;
                }
                case 4: {
                    value = this.memory.getInt(a);
                    break;
                }
                case 2: {
                    value = this.memory.getShort(a);
                    break;
                }
                case 1: {
                    value = this.memory.getByte(a);
                    break;
                }
                default: {
                    return null;
                }
            }
            return a.getNewAddress(value);
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private boolean isUndefined(Address a) {
        int length = a.getAddressSpace().getSize() / 4;
        for (int i = 0; i < length; ++i) {
            if (this.listing.getUndefinedDataAt(a) == null) {
                return false;
            }
            try {
                a = a.addNoWrap(1L);
                continue;
            }
            catch (AddressOverflowException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public void setProgram(Program program) {
        if (program == null) {
            this.listing = null;
            this.memory = null;
        } else {
            this.listing = program.getListing();
            this.memory = program.getMemory();
        }
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Address");
    }

    @Override
    public void dispose() {
        this.listing = null;
        this.memory = null;
    }
}

