/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.EmptyTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import ghidra.app.plugin.core.byteviewer.FieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.util.datastruct.ListenerSet;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;

public class ByteViewerLayoutModel
implements LayoutModel {
    private int width;
    private IndexMap indexMap;
    private ListenerSet<LayoutModelListener> listeners = new ListenerSet(LayoutModelListener.class, false);
    private FieldFactory[] factorys = new FieldFactory[0];

    void dispose() {
        this.indexMap = null;
        this.factorys = null;
        this.listeners.clear();
    }

    void setFactorys(FieldFactory[] fieldFactorys, DataFormatModel dataModel, int margin) {
        this.factorys = new FieldFactory[fieldFactorys.length];
        int x = margin;
        int defaultGroupSizeSpace = 1;
        for (int i = 0; i < this.factorys.length; ++i) {
            this.factorys[i] = fieldFactorys[i];
            this.factorys[i].setStartX(x);
            x += this.factorys[i].getWidth();
            if ((i + 1) % defaultGroupSizeSpace != 0) continue;
            x += margin * dataModel.getUnitDelimiterSize();
        }
        this.width = x - margin * dataModel.getUnitDelimiterSize() + margin;
        this.layoutChanged();
    }

    void setIndexMap(IndexMap indexMap) {
        if (indexMap == this.indexMap) {
            return;
        }
        this.indexMap = indexMap;
        this.indexSetChanged();
    }

    public void indexSetChanged() {
        ((LayoutModelListener)this.listeners.invoke()).modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
    }

    public void layoutChanged() {
        ((LayoutModelListener)this.listeners.invoke()).dataChanged(BigInteger.ZERO, this.getNumIndexes());
    }

    public void dataChanged(BigInteger startIndex, BigInteger endIndex) {
        ((LayoutModelListener)this.listeners.invoke()).dataChanged(startIndex, endIndex);
    }

    public boolean isUniform() {
        return true;
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(this.width, 500);
    }

    public BigInteger getNumIndexes() {
        return this.indexMap != null ? this.indexMap.getNumIndexes() : BigInteger.ZERO;
    }

    public Layout getLayout(BigInteger index) {
        if (index.compareTo(BigInteger.ZERO) < 0 || index.compareTo(this.getNumIndexes()) >= 0) {
            return null;
        }
        ArrayList<Object> fields = new ArrayList<Object>(this.factorys.length);
        for (FieldFactory factory : this.factorys) {
            Field field = factory.getField(index);
            if (field == null) continue;
            fields.add(field);
        }
        if (fields.size() == 0) {
            if (this.factorys.length > 0) {
                FontMetrics fm = this.factorys[0].getMetrics();
                int height = fm.getMaxAscent() + fm.getMaxDescent();
                fields.add(new EmptyTextField(height, this.factorys[0].getStartX(), 0, this.factorys[0].getWidth()));
            } else {
                fields.add(new EmptyTextField(20, 0, 0, 10));
            }
        }
        Field[] fieldArray = new Field[fields.size()];
        fields.toArray(fieldArray);
        return new SingleRowLayout(fieldArray);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.getNumIndexes()) >= 0) {
            return null;
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        BigInteger numIndexes = this.getNumIndexes();
        if (numIndexes.compareTo(BigInteger.ZERO) <= 0 || index.compareTo(BigInteger.ZERO) <= 0) {
            return null;
        }
        if (index.compareTo(numIndexes) > 0) {
            return numIndexes.subtract(BigInteger.ONE);
        }
        BigInteger previousIndex = index.subtract(BigInteger.ONE);
        return previousIndex;
    }

    public void flushChanges() {
    }
}

