/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.GhidraOptions;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteViewerActionContext;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.byteviewer.ByteViewerOptionsDialog;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Font;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class ByteViewerComponentProvider
extends ComponentProviderAdapter
implements OptionsChangeListener,
PopupActionProvider {
    protected static final String BLOCK_NUM = "Block Num";
    protected static final String BLOCK_OFFSET = "Block Offset";
    protected static final String BLOCK_COLUMN = "Block Column";
    protected static final String INDEX = "Index";
    protected static final String X_OFFSET = "X Offset";
    protected static final String Y_OFFSET = "Y Offset";
    private static final String VIEW_NAMES = "View Names";
    private static final String VIEW_WIDTHS = "View_Widths";
    static final int DEFAULT_NUMBER_OF_CHARS = 8;
    static final String DEFAULT_FONT_ID = "font.byteviewer";
    static final Font DEFAULT_FONT = Gui.getFont((String)"font.byteviewer");
    static final String HEADER_FONT_ID = "font.byteviewer.header";
    static final Font HEADER_FONT = Gui.getFont((String)"font.byteviewer.header");
    static final GColor FG_COLOR = new GColor("color.fg");
    static final GColor BG_COLOR = new GColor("color.bg.byteviewer");
    static final GColor SEPARATOR_COLOR = new GColor("color.fg.byteviewer.separator");
    static final GColor EDITED_TEXT_COLOR = new GColor("color.fg.byteviewer.changed");
    static final GColor CURSOR_COLOR_FOCUSED_EDIT = new GColor("color.cursor.byteviewer.focused.edit");
    static final GColor CURSOR_COLOR_UNFOCUSED_EDIT = new GColor("color.cursor.byteviewer.unfocused.edit");
    static final GColor CURSOR_COLOR_FOCUSED_NON_EDIT = new GColor("color.cursor.byteviewer.focused.non.edit");
    static final GColor CURSOR_COLOR_UNFOCUSED_NON_EDIT = new GColor("color.cursor.byteviewer.unfocused.non.edit");
    static final GColor CURRENT_LINE_COLOR = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    static final GColor HIGHLIGHT_COLOR = new GColor("color.bg.byteviewer.highlight");
    static final GColor HIGHLIGHT_MIDDLE_MOUSE_COLOR = new GColor("color.bg.byteviewer.highlight.middle.mouse");
    static final String INDEX_COLUMN_NAME = "Addresses";
    static final String SEPARATOR_COLOR_OPTION_NAME = "Block Separator Color";
    static final String EDIT_TEXT_COLOR_OPTION_NAME = "Edited Text Color";
    static final String CURSOR_FOCUSED_COLOR_OPTION_NAME = "Cursor Color Focused";
    static final String CURSOR_UNFOCUSED_COLOR_OPTION_NAME = "Cursor Color Unfocused";
    static final String CURSOR_FOCUSED_EDIT_COLOR_OPTION_NAME = "Cursor Color Focused Edit";
    static final String CURSOR_UNFOCUSED_EDIT_COLOR_OPTION_NAME = "Cursor Color Unfocused Edit";
    static final String OPTION_FONT = "Font";
    private static final String DEFAULT_VIEW = "Hex";
    private static final String OPTION_HIGHLIGHT_CURSOR_LINE = "Highlight Cursor Line";
    private static final String OPTION_HIGHLIGHT_MIDDLE_MOUSE_NAME = "Middle Mouse Color";
    protected ByteViewerPanel panel;
    private ByteViewerConfigOptions configOptions = new ByteViewerConfigOptions();
    protected Map<String, ByteViewerComponent> viewMap = new HashMap<String, ByteViewerComponent>();
    protected ToggleDockingAction editModeAction;
    protected ProgramByteBlockSet blockSet;
    protected final AbstractByteViewerPlugin<?> plugin;
    protected SwingUpdateManager updateManager;
    private Map<String, Class<? extends DataFormatModel>> dataFormatModelClassMap;
    private DockingAction shiftLeftAction;
    private DockingAction shiftRightAction;
    private DockingAction optionsAction;

    protected ByteViewerComponentProvider(PluginTool tool, AbstractByteViewerPlugin<?> plugin, String name, Class<?> contextType) {
        super(tool, name, plugin.getName(), contextType);
        this.plugin = plugin;
        this.registerAdjustableFontId(DEFAULT_FONT_ID);
        this.initializedDataFormatModelClassMap();
        this.panel = this.newByteViewerPanel();
        this.setIcon((Icon)new GIcon("icon.plugin.byteviewer.provider"));
        this.setOptions();
        this.createActions();
        this.updateManager = new SwingUpdateManager(1000, 3000, () -> this.refreshView());
        this.addView(DEFAULT_VIEW);
        this.setWindowMenuGroup("Byte Viewer");
        tool.addPopupActionProvider((PopupActionProvider)this);
    }

    protected ByteViewerPanel newByteViewerPanel() {
        return new ByteViewerPanel(this);
    }

    private void initializedDataFormatModelClassMap() {
        this.dataFormatModelClassMap = new HashMap<String, Class<? extends DataFormatModel>>();
        Set<DataFormatModel> models = this.getDataFormatModels();
        for (DataFormatModel model : models) {
            this.dataFormatModelClassMap.put(model.getName(), model.getClass());
        }
    }

    ToggleDockingAction getEditModeAction() {
        return this.editModeAction;
    }

    DockingAction getShiftLeftAction() {
        return this.shiftLeftAction;
    }

    DockingAction getShiftRightAction() {
        return this.shiftRightAction;
    }

    DockingAction getOptionsAction() {
        return this.optionsAction;
    }

    private void createActions() {
        this.editModeAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Enable/Disable Byteviewer Editing", this.plugin.getName()).selected(false).description("Enable/Disable editing of bytes in Byte Viewer panels.")).toolBarIcon((Icon)new GIcon("icon.base.edit.bytes"))).toolBarGroup("Byteviewer")).keyBinding(KeyStroke.getKeyStroke(69, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x200))).enabledWhen(ac -> this.blockSet != null && this.blockSet.isValid())).onAction(ac -> this.setEditMode(this.editModeAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.optionsAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Byte Viewer Options", this.plugin.getName()).description("Set Byte Viewer Options")).toolBarIcon((Icon)new GIcon("icon.plugin.byteviewer.options"))).toolBarGroup("ZSettings")).enabledWhen(ac -> this.blockSet != null && this.blockSet.isValid())).onAction(ac -> this.tool.showDialog((DialogComponentProvider)new ByteViewerOptionsDialog(this), (ComponentProvider)this))).buildAndInstallLocal((ComponentProvider)this);
        this.shiftLeftAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Shift Alignment Offset Left", this.plugin.getName()).description("Shift Alignment Offset Left")).popupMenuGroup("ByteOffsetShift")).popupMenuPath(new String[]{"Shift Bytes Left"})).keyBinding("ctrl-comma")).enabledWhen(ac -> this.blockSet != null && this.blockSet.isValid())).onAction(ac -> this.adjustOffset(-1))).buildAndInstallLocal((ComponentProvider)this);
        this.shiftRightAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Shift Alignment Offset Right", this.plugin.getName()).description("Shift Alignment Offset Right")).popupMenuGroup("ByteOffsetShift")).popupMenuPath(new String[]{"Shift Bytes Right"})).keyBinding("ctrl-period")).enabledWhen(ac -> this.blockSet != null && this.blockSet.isValid())).onAction(ac -> this.adjustOffset(1))).buildAndInstallLocal((ComponentProvider)this);
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        ByteViewerActionContext bvContext;
        if (context instanceof ByteViewerActionContext && (bvContext = (ByteViewerActionContext)context).getComponentProvider() == this) {
            return bvContext.getActiveColumn().getPopupActions(t, (ActionContext)bvContext);
        }
        return null;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "ByteViewerPlugin");
    }

    protected ByteBlock[] getByteBlocks() {
        return this.blockSet == null ? null : this.blockSet.getBlocks();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (options.getName().equals("Listing Fields")) {
            if (optionName.equals("Cursor Text Highlight.Mouse Button To Activate")) {
                GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)newValue;
                this.panel.setHighlightButton(mouseButton.getMouseEventID());
            }
        } else if (options.getName().equals("ByteViewer") && optionName.equals(OPTION_HIGHLIGHT_CURSOR_LINE)) {
            this.panel.setHighlightCurrentLineEnabled((Boolean)newValue);
        }
    }

    private void setOptions() {
        ToolOptions opt = this.tool.getOptions("ByteViewer");
        HelpLocation help = new HelpLocation("ByteViewerPlugin", "Option");
        opt.setOptionsHelpLocation(help);
        opt.registerThemeColorBinding(SEPARATOR_COLOR_OPTION_NAME, SEPARATOR_COLOR.getId(), help, "Color used for separator shown between memory blocks.");
        opt.registerThemeColorBinding(EDIT_TEXT_COLOR_OPTION_NAME, EDITED_TEXT_COLOR.getId(), new HelpLocation("ByteViewerPlugin", "EditColor"), "Color of changed bytes when editing.");
        opt.registerThemeColorBinding(CURSOR_FOCUSED_COLOR_OPTION_NAME, CURSOR_COLOR_FOCUSED_NON_EDIT.getId(), help, "Color of cursor in the focused view.");
        opt.registerThemeColorBinding(CURSOR_UNFOCUSED_COLOR_OPTION_NAME, CURSOR_COLOR_UNFOCUSED_NON_EDIT.getId(), help, "Color of cursor in the unfocused views.");
        opt.registerThemeColorBinding(CURSOR_FOCUSED_EDIT_COLOR_OPTION_NAME, CURSOR_COLOR_FOCUSED_EDIT.getId(), help, "Color of the cursor in the focused view when editing.");
        opt.registerThemeColorBinding(CURSOR_UNFOCUSED_EDIT_COLOR_OPTION_NAME, CURSOR_COLOR_UNFOCUSED_EDIT.getId(), help, "Color of the cursor in the unfocused view when editing.");
        opt.registerThemeColorBinding(OPTION_HIGHLIGHT_MIDDLE_MOUSE_NAME, HIGHLIGHT_MIDDLE_MOUSE_COLOR.getId(), help, "The middle-mouse highlight color.");
        opt.registerThemeFontBinding(OPTION_FONT, DEFAULT_FONT_ID, help, "Font used in the views.");
        boolean highlightCurrentLine = true;
        opt.registerOption(OPTION_HIGHLIGHT_CURSOR_LINE, (Object)highlightCurrentLine, help, "Toggles highlighting background color of line containing the cursor.");
        this.panel.setHighlightCurrentLineEnabled(highlightCurrentLine);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Listing Fields");
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)opt.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.panel.setHighlightButton(mouseButton.getMouseEventID());
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setOffset(int newOffset) {
        if (this.configOptions.calcNormalizedOffset(newOffset) != this.configOptions.getOffset()) {
            this.configOptions.setOffset(newOffset);
            ViewerPosition vp = this.panel.getViewerPosition();
            this.panel.updateLayoutConfigOptions(this.configOptions);
            this.tool.setConfigChanged(true);
            this.panel.setViewerPosition(vp);
        }
    }

    void adjustOffset(int delta) {
        this.setOffset(this.configOptions.getOffset() + delta);
    }

    ByteBlockInfo getCursorLocation() {
        return this.panel.getCursorLocation();
    }

    ByteBlockSet getByteBlockSet() {
        return this.blockSet;
    }

    public ByteViewerConfigOptions getConfigOptions() {
        return this.configOptions;
    }

    public void updateConfigOptions(ByteViewerConfigOptions newOptions, Set<String> selectedViews) {
        boolean changed = this.removeDeletedViews(selectedViews);
        if (!this.configOptions.areOptionsEqual(newOptions)) {
            changed = true;
            boolean layoutChanged = this.configOptions.areLayoutParamsChanged(newOptions);
            boolean widthsChanged = this.configOptions.areDislayWidthsChanged(newOptions);
            this.configOptions = newOptions;
            for (ByteViewerComponent bvc : this.viewMap.values()) {
                bvc.getDataModel().setByteViewerConfigOptions(this.configOptions);
                bvc.invalidateModelFields();
            }
            if (layoutChanged || widthsChanged) {
                this.panel.updateLayoutConfigOptions(this.configOptions);
            }
            if (widthsChanged) {
                this.panel.resetColumnsToDefaultWidths();
            }
            this.panel.invalidate();
            this.panel.validate();
            this.panel.repaint();
        }
        if (changed |= this.addNewViews(selectedViews)) {
            this.refreshView();
            this.tool.setConfigChanged(true);
        }
    }

    private boolean removeDeletedViews(Set<String> selectedViews) {
        if (selectedViews == null) {
            return false;
        }
        boolean changed = false;
        for (String viewName : this.getCurrentViews()) {
            if (selectedViews.contains(viewName)) continue;
            this.removeView(viewName, true);
            changed = true;
        }
        return changed;
    }

    private boolean addNewViews(Set<String> selectedViews) {
        if (selectedViews == null) {
            return false;
        }
        boolean changed = false;
        Set<String> currentViews = this.getCurrentViews();
        for (String viewName : selectedViews) {
            if (currentViews.contains(viewName)) continue;
            this.addView(viewName);
            changed = true;
        }
        return changed;
    }

    private void updateModelConfig(String modelName) {
        ByteViewerComponent bvc = this.viewMap.get(modelName);
        if (bvc != null) {
            bvc.getDataModel().setByteViewerConfigOptions(this.configOptions);
            bvc.invalidateModelFields();
            this.panel.repaint();
        }
    }

    public void setCharsetInfo(CharsetInfo newCSI) {
        CharsetInfo oldCSI = this.configOptions.getCharsetInfo();
        if (!oldCSI.equals((Object)newCSI)) {
            this.configOptions.setCharsetInfo(newCSI);
            this.updateModelConfig("Chars");
            if (oldCSI.getAlignment() != newCSI.getAlignment()) {
                this.panel.resetColumnsToDefaultWidths();
            }
            this.tool.setConfigChanged(true);
        }
    }

    public void setCompactChars(boolean newCompactChars) {
        if (this.configOptions.isCompactChars() != newCompactChars) {
            this.configOptions.setCompactChars(newCompactChars);
            this.updateModelConfig("Chars");
            this.panel.resetColumnsToDefaultWidths();
            this.tool.setConfigChanged(true);
        }
    }

    protected void writeConfigState(SaveState saveState) {
        List<String> viewNames = this.panel.getViewNamesInDisplayOrder();
        saveState.putStrings(VIEW_NAMES, viewNames.toArray(new String[viewNames.size()]));
        this.configOptions.write(saveState);
        SaveState columnState = new SaveState(VIEW_WIDTHS);
        int indexWidth = this.panel.getViewWidth(INDEX_COLUMN_NAME);
        columnState.putInt(INDEX_COLUMN_NAME, indexWidth);
        for (String viewName : viewNames) {
            int width = this.panel.getViewWidth(viewName);
            columnState.putInt(viewName, width);
        }
        saveState.putSaveState(VIEW_WIDTHS, columnState);
    }

    protected void readConfigState(SaveState saveState) {
        this.configOptions.read(saveState);
        String[] names = saveState.getStrings(VIEW_NAMES, new String[0]);
        this.restoreViews(names, false);
        this.panel.restoreConfigState(this.configOptions);
        SaveState viewWidths = saveState.getSaveState(VIEW_WIDTHS);
        if (viewWidths != null) {
            String[] viewNames;
            for (String viewName : viewNames = viewWidths.getNames()) {
                int width = viewWidths.getInt(viewName, 0);
                if (width <= 0) continue;
                this.panel.setViewWidth(viewName, width);
            }
        }
    }

    private void restoreViews(String[] viewNames, boolean updateViewPosition) {
        for (String viewName : List.copyOf(this.viewMap.keySet())) {
            this.removeView(viewName, false);
        }
        for (String viewName : viewNames) {
            DataFormatModel dataFormatModel = this.getDataFormatModel(viewName);
            if (dataFormatModel == null) continue;
            this.addView(dataFormatModel, false, updateViewPosition);
        }
        if (this.viewMap.isEmpty()) {
            this.addView(DEFAULT_VIEW);
        }
    }

    void addView(String modelName) {
        DataFormatModel dataFormatModel = this.getDataFormatModel(modelName);
        if (dataFormatModel != null) {
            this.addView(dataFormatModel, false, true);
        }
    }

    private ByteViewerComponent addView(DataFormatModel model, boolean configChanged, boolean updateViewPosition) {
        model.setByteViewerConfigOptions(this.configOptions);
        String viewName = model.getName();
        ByteViewerComponent bvc = this.panel.addView(viewName, model, updateViewPosition);
        this.viewMap.put(viewName, bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
        return bvc;
    }

    void removeView(String viewName, boolean configChanged) {
        ByteViewerComponent bvc = this.viewMap.remove(viewName);
        if (bvc == null) {
            return;
        }
        this.panel.removeView(bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
    }

    protected abstract void updateLocation(ByteBlock var1, BigInteger var2, int var3, boolean var4);

    protected abstract void updateSelection(ByteBlockSelection var1);

    protected abstract void updateLiveSelection(ByteViewerComponent var1, ByteBlockSelection var2);

    void dispose() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        this.updateManager.dispose();
        this.updateManager = null;
        this.panel.dispose();
        if (this.blockSet != null) {
            this.blockSet.dispose();
        }
        this.blockSet = null;
    }

    public Set<String> getCurrentViews() {
        return new HashSet<String>(this.panel.getViewNamesInDisplayOrder());
    }

    private void refreshView() {
        if (this.tool == null) {
            return;
        }
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.panel.refreshView();
        }
    }

    protected ByteViewerPanel getByteViewerPanel() {
        return this.panel;
    }

    void setStatusMessage(String message) {
        this.plugin.setStatusMessage(message);
    }

    void setEditMode(boolean isEditable) {
        this.panel.setEditMode(isEditable);
    }

    protected Set<DataFormatModel> getDataFormatModels() {
        HashSet<DataFormatModel> set = new HashSet<DataFormatModel>();
        set.addAll(ClassSearcher.getInstances(UniversalDataFormatModel.class));
        return set;
    }

    public List<String> getDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>(this.dataFormatModelClassMap.keySet());
        Collections.sort(names);
        return names;
    }

    public DataFormatModel getDataFormatModel(String formatName) {
        Class<? extends DataFormatModel> classy = this.dataFormatModelClassMap.get(formatName);
        if (classy == null) {
            return null;
        }
        try {
            return classy.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error loading ByteViewer model formats", (Throwable)e);
            return null;
        }
    }

    public MarkerService getMarkerService() {
        return (MarkerService)this.tool.getService(MarkerService.class);
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.panel.addDisplayListener(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.panel.removeDisplayListener(listener);
    }
}

