/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.util.GraphicsUtils;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.SimpleTextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.math.BigInteger;
import javax.swing.JComponent;

public class ByteField
extends SimpleTextField {
    private int fieldOffset;
    private BigInteger index;
    private int cursorWidth;

    public ByteField(String text, FontMetrics fontMetrics, int startX, int width, int charWidth, boolean allowCursorAtEnd, int fieldOffset, BigInteger index, FieldHighlightFactory hlFactory) {
        super(text, fontMetrics, startX, width, allowCursorAtEnd, hlFactory);
        this.fieldOffset = fieldOffset;
        this.index = index;
        this.cursorWidth = charWidth;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        this.paintSelection(g, colorManager, 0);
        this.paintHighlights(g, this.hlFactory.createHighlights((Field)this, this.text, -1));
        g.setFont(this.metrics.getFont());
        if (this.foregroundColor == null) {
            this.foregroundColor = context.getForeground();
        }
        g.setColor(this.foregroundColor);
        GraphicsUtils.drawString((JComponent)c, (Graphics)g, (String)this.text, (int)this.startX, (int)0);
        Color cursorColor = context.getCursorColor();
        this.paintCursor(c, g, cursorColor, cursorLoc, context.cursorHidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCursor(JComponent c, Graphics g, Color cursorColor, RowColLocation cursorLoc, boolean cursorHidden) {
        if (cursorLoc == null) {
            return;
        }
        if (cursorLoc.col() >= this.numCols) {
            return;
        }
        g.setColor(cursorColor);
        int x = this.startX + this.metrics.stringWidth(this.text.substring(0, cursorLoc.col()));
        g.fillRect(x, -this.heightAbove, this.cursorWidth, this.heightAbove + this.heightBelow);
        if (cursorHidden) {
            return;
        }
        Shape oldClip = g.getClip();
        try {
            g.setClip(x, -this.heightAbove, this.cursorWidth, this.heightAbove + this.heightBelow);
            Color textColor = ColorUtils.contrastForegroundColor((Color)cursorColor);
            g.setColor(textColor);
            GraphicsUtils.drawString((JComponent)c, (Graphics)g, (String)this.text, (int)this.startX, (int)0);
        }
        finally {
            g.setClip(oldClip);
        }
    }

    public int getFieldOffset() {
        return this.fieldOffset;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getText();
    }
}

