/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class OffcutReferenceCountToAddressTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<Address, Integer> {
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Offcut Reference Count";
    }

    public Integer getValue(Address address, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        CodeUnit codeUnit;
        int count = 0;
        if (address.isMemoryAddress() && (codeUnit = program.getListing().getCodeUnitContaining(address)) != null) {
            AddressSet set = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
            set.deleteRange(address, address);
            ReferenceManager referenceManager = program.getReferenceManager();
            AddressIterator it = referenceManager.getReferenceDestinationIterator((AddressSetView)set, true);
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }
}

