/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset.picker;

import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.picker.CharsetInfoPanel;
import ghidra.util.charset.picker.CharsetTableModel;
import ghidra.util.charset.picker.CharsetTableRow;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CharsetPickerPanel
extends JPanel {
    private GhidraTable table;
    private CharsetTableModel tableModel = new CharsetTableModel();
    private GhidraTableFilterPanel<CharsetTableRow> tableFilterPanel;
    private Consumer<Charset> charsetListener;
    private CharsetInfo selectedCSI;

    public CharsetPickerPanel(Consumer<Charset> charsetListener) {
        super(new BorderLayout());
        this.build();
        this.charsetListener = charsetListener;
    }

    private void build() {
        this.table = new GhidraTable((TableModel)((Object)this.tableModel));
        this.table.setVisibleRowCount(10);
        this.table.setSelectionMode(0);
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        CharsetInfoPanel detailsPanel = new CharsetInfoPanel();
        detailsPanel.getAccessibleContext().setAccessibleName("Details");
        detailsPanel.setBorder(BorderFactory.createTitledBorder("Details"));
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)scrollPane, "Center");
        innerPanel.add((Component)((Object)this.tableFilterPanel), "South");
        innerPanel.getAccessibleContext().setAccessibleName("Table Filter");
        this.add((Component)innerPanel, "Center");
        this.add((Component)detailsPanel, "South");
        this.table.getSelectionModel().addListSelectionListener(e -> {
            CharsetTableRow row;
            if (!e.getValueIsAdjusting() && (row = (CharsetTableRow)this.tableFilterPanel.getSelectedItem()) != null) {
                this.selectedCSI = row.csi();
                detailsPanel.setCharset(row.csi());
                if (this.charsetListener != null) {
                    this.charsetListener.accept(row.csi().getCharset());
                }
            }
        });
        TableColumn col = this.table.getColumnModel().getColumn(3);
        col.setMaxWidth(100);
        col = this.table.getColumnModel().getColumn(4);
        col.setMaxWidth(100);
        col = this.table.getColumnModel().getColumn(2);
        col.setMaxWidth(100);
    }

    public void setSelectedCharset(CharsetInfo csi) {
        int rowNum = this.tableModel.findCharset(csi);
        if (rowNum >= 0) {
            this.table.getSelectionManager().setSelectionInterval(rowNum, rowNum);
            this.table.scrollToSelectedRow();
        }
    }

    public void setCharsetListener(Consumer<Charset> charsetListener) {
        this.charsetListener = charsetListener;
    }

    public CharsetInfo getSelectedCharset() {
        return this.selectedCSI;
    }
}

