/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset.picker;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.util.HelpLocation;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.picker.CharsetPickerPanel;

public class CharsetPickerDialog
extends DialogComponentProvider {
    private CharsetPickerPanel panel = new CharsetPickerPanel(null);
    private CharsetInfo csi;

    public static CharsetInfo pickCharset(CharsetInfo defaultCSI) {
        CharsetPickerDialog dlg = new CharsetPickerDialog();
        dlg.setSelectedCharset(defaultCSI);
        DockingWindowManager.showDialog((DialogComponentProvider)dlg);
        return dlg.getSelectedCharset();
    }

    public CharsetPickerDialog() {
        super("Pick Charset", true, false, true, false);
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultSize(800, 800);
        this.setRememberLocation(false);
        this.setHelpLocation(new HelpLocation("Charsets", "CharsetPicker"));
    }

    protected void okCallback() {
        this.csi = this.panel.getSelectedCharset();
        this.close();
    }

    protected void cancelCallback() {
        this.csi = null;
        super.cancelCallback();
    }

    public void setSelectedCharset(CharsetInfo csi) {
        this.panel.setSelectedCharset(csi);
    }

    public CharsetInfo getSelectedCharset() {
        return this.csi;
    }
}

