/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import java.util.Objects;

public class Match<T> {
    private T pattern;
    private long start;
    private int length;

    public Match(T pattern, long start, int length) {
        this.pattern = pattern;
        this.start = start;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public long getStart() {
        return this.start;
    }

    public T getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern.toString() + " @ " + this.start;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.start, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Match other = (Match)obj;
        return Objects.equals(this.pattern, other.pattern) && this.start == other.start && this.length == other.length;
    }
}

