/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.ByteSequence;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamBufferByteSequence
implements ByteSequence {
    private byte[] bytes;
    private int validDataLength;

    public InputStreamBufferByteSequence(int bufferSize) {
        this.bytes = new byte[bufferSize];
    }

    public void load(InputStream is, int amount) throws IOException {
        if (amount > this.bytes.length) {
            throw new IllegalArgumentException("Attempted to read greater that buffer size!");
        }
        int numRead = is.read(this.bytes, 0, amount);
        this.validDataLength = numRead >= 0 ? numRead : 0;
    }

    @Override
    public int getLength() {
        return this.validDataLength;
    }

    @Override
    public byte getByte(int index) {
        return this.bytes[index];
    }

    @Override
    public boolean hasAvailableBytes(int index, int length) {
        return index >= 0 && index + length <= this.validDataLength;
    }

    @Override
    public byte[] getBytes(int index, int length) {
        if (index < 0 || index + length > this.validDataLength) {
            throw new IndexOutOfBoundsException();
        }
        byte[] results = new byte[length];
        System.arraycopy(this.bytes, index, results, 0, length);
        return results;
    }
}

