/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import org.junit.Assert;

public class MockHttpServerUtils {
    private static int LAST_SERVER_PORT_NUM = 13000;
    public static final String CONTENT_TYPE_HEADER = "Content-Type";

    public static URI getURI(InetSocketAddress addr) {
        return URI.create("http://%s:%d".formatted(addr.getHostString(), addr.getPort()));
    }

    public static InetSocketAddress nextLoopbackServerAddr() {
        InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getLoopbackAddress(), LAST_SERVER_PORT_NUM);
        ++LAST_SERVER_PORT_NUM;
        return serverAddr;
    }

    public static HttpServer createMockHttpServer() throws IOException {
        IOException lastException = null;
        for (int retryNum = 0; retryNum < 10; ++retryNum) {
            InetSocketAddress serverAddress = MockHttpServerUtils.nextLoopbackServerAddr();
            try {
                HttpServer server = HttpServer.create(serverAddress, 0);
                return server;
            }
            catch (IOException e) {
                lastException = e;
                continue;
            }
        }
        throw new IOException("Could not allocate port for mock http server, last attempted port: " + LAST_SERVER_PORT_NUM, lastException);
    }

    public static void assertContentType(String expectedType, HttpExchange httpExchange) {
        String contentType = httpExchange.getRequestHeaders().getFirst(CONTENT_TYPE_HEADER);
        if (!expectedType.equals(contentType = Objects.requireNonNullElse(contentType, "missing"))) {
            Assert.fail((String)"Content type incorrect: expected: %s, actual: %s".formatted(expectedType, contentType));
        }
    }

    public static HttpHandler wrapHandlerWithDelay(HttpHandler delegate, int delayMS) {
        return httpExchange -> {
            try {
                Thread.sleep(delayMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delegate.handle(httpExchange);
        };
    }

    public static HttpHandler wrapHandlerWithRetryError(final HttpHandler delegate, final int errorCount, final int errorStatus) {
        return new HttpHandler(){
            int errorNum;

            @Override
            public void handle(HttpExchange exchange) throws IOException {
                if (this.errorNum++ < errorCount) {
                    exchange.sendResponseHeaders(errorStatus, 0L);
                    exchange.close();
                    return;
                }
                delegate.handle(exchange);
            }
        };
    }

    public static void mock404Handler(HttpExchange httpExchange) throws IOException {
        try {
            httpExchange.sendResponseHeaders(404, 0L);
        }
        finally {
            httpExchange.close();
        }
    }

    public static HttpHandler createStaticResponseHandler(String contentType, byte[] resultBody) {
        return MockHttpServerUtils.createStaticResponseHandler(200, contentType, resultBody);
    }

    public static HttpHandler createStaticResponseHandler(int resultCode, String contentType, byte[] resultBody) {
        return httpExchange -> {
            try {
                byte[] actualResult = (byte[])(httpExchange.getRequestMethod().equals("GET") ? resultBody : null);
                httpExchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, contentType);
                httpExchange.sendResponseHeaders(resultCode, actualResult != null ? (long)actualResult.length : -1L);
                if (actualResult != null) {
                    httpExchange.getResponseBody().write(resultBody);
                }
            }
            catch (Throwable th) {
                MockHttpServerUtils.logMockHttp(httpExchange, "Error during mockStaticResponseHandler: " + th.getMessage());
                throw th;
            }
            finally {
                httpExchange.close();
            }
        };
    }

    public static void logMockHttp(HttpExchange httpExchange, String msg) {
        Msg.info(MockHttpServerUtils.class, (Object)"[%s %s] %s".formatted(httpExchange.getLocalAddress(), httpExchange.getRequestURI(), msg));
    }
}

