/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.searcher;

import ghidra.program.model.address.Address;
import java.util.Arrays;
import java.util.Objects;

public class MemoryMatch<T>
implements Comparable<MemoryMatch<T>> {
    private final Address address;
    private byte[] bytes;
    private byte[] previousBytes;
    private final T pattern;

    public MemoryMatch(Address address, byte[] bytes, T pattern) {
        if (bytes == null || bytes.length < 1) {
            throw new IllegalArgumentException("Must provide at least 1 byte");
        }
        this.address = Objects.requireNonNull(address);
        this.bytes = bytes;
        this.previousBytes = bytes;
        this.pattern = pattern;
    }

    public MemoryMatch(Address address) {
        this.address = address;
        this.pattern = null;
    }

    public void updateBytes(byte[] newBytes) {
        this.previousBytes = this.bytes;
        if (!Arrays.equals(this.bytes, newBytes)) {
            this.bytes = newBytes;
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public int getLength() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getPreviousBytes() {
        return this.previousBytes;
    }

    public T getPattern() {
        return this.pattern;
    }

    @Override
    public int compareTo(MemoryMatch<T> o) {
        return this.address.compareTo((Object)o.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryMatch other = (MemoryMatch)obj;
        return Objects.equals(this.address, other.address);
    }

    public String toString() {
        return this.address.toString();
    }

    public boolean isChanged() {
        return !this.bytes.equals(this.previousBytes);
    }
}

