/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.searcher;

import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import java.util.function.Predicate;

public class CodeUnitFilter
implements Predicate<MemoryMatch<SearchData>> {
    private boolean includeInstructions;
    private boolean includeUndefinedData;
    private boolean includeDefinedData;
    private boolean includeAll;
    private Listing listing;

    public CodeUnitFilter(Program program, boolean includeInstructions, boolean includeDefinedData, boolean includeUndefinedData) {
        this.listing = program.getListing();
        this.includeInstructions = includeInstructions;
        this.includeDefinedData = includeDefinedData;
        this.includeUndefinedData = includeUndefinedData;
        this.includeAll = includeInstructions && includeDefinedData && includeUndefinedData;
    }

    @Override
    public boolean test(MemoryMatch match) {
        if (this.includeAll) {
            return true;
        }
        CodeUnit codeUnit = this.listing.getCodeUnitContaining(match.getAddress());
        if (codeUnit instanceof Instruction) {
            return this.includeInstructions;
        }
        if (codeUnit instanceof Data) {
            Data data = (Data)codeUnit;
            if (data.isDefined()) {
                return this.includeDefinedData;
            }
            return this.includeUndefinedData;
        }
        return false;
    }
}

