/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.util.bytesearch.ExtendedByteSequence;
import ghidra.util.bytesearch.Match;
import java.util.Objects;

public abstract class UserInputByteMatcher
implements ByteMatcher<SearchData> {
    protected final SearchData searchData;

    protected UserInputByteMatcher(String name, String input, SearchSettings settings) {
        this.searchData = new SearchData(name, input, settings);
    }

    public String getName() {
        return this.searchData.getName();
    }

    @Override
    public abstract Iterable<Match<SearchData>> match(ExtendedByteSequence var1);

    @Override
    public abstract String getDescription();

    public abstract String getToolTip();

    public boolean isValidSearch() {
        return true;
    }

    public boolean isValidInput() {
        return true;
    }

    public String toString() {
        return this.searchData.getInput();
    }

    public int hashCode() {
        return this.searchData.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInputByteMatcher other = (UserInputByteMatcher)obj;
        return Objects.equals(this.searchData, other.searchData);
    }

    public SearchSettings getSettings() {
        return this.searchData.getSettings();
    }

    public String getInput() {
        return this.searchData.getInput();
    }

    public SearchData getSearchData() {
        return this.searchData;
    }
}

