/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.matcher.UserInputByteMatcher;
import ghidra.util.bytesearch.ExtendedByteSequence;
import ghidra.util.bytesearch.Match;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;

public class RegExByteMatcher
extends UserInputByteMatcher {
    private final Pattern pattern;

    public RegExByteMatcher(String input, SearchSettings settings) {
        this("Regex Matcher", input, settings);
    }

    public RegExByteMatcher(String name, String input, SearchSettings settings) {
        super(name, input, settings);
        this.pattern = Pattern.compile(input, 32);
    }

    @Override
    public Iterable<Match<SearchData>> match(ExtendedByteSequence byteSequence) {
        return new PatternMatchIterator(byteSequence);
    }

    @Override
    public String getDescription() {
        return "Reg Ex";
    }

    @Override
    public String getToolTip() {
        return null;
    }

    private class PatternMatchIterator
    implements Iterable<Match<SearchData>>,
    Iterator<Match<SearchData>> {
        private Matcher matcher;
        private Match<SearchData> nextMatch;
        private ExtendedByteSequence byteSequence;

        public PatternMatchIterator(ExtendedByteSequence byteSequence) {
            this.byteSequence = byteSequence;
            this.matcher = RegExByteMatcher.this.pattern.matcher(new ByteCharSequence(RegExByteMatcher.this, byteSequence));
            this.nextMatch = this.findNextMatch();
        }

        @Override
        public boolean hasNext() {
            return this.nextMatch != null;
        }

        @Override
        public Match<SearchData> next() {
            if (this.nextMatch == null) {
                return null;
            }
            Match<SearchData> returnValue = this.nextMatch;
            this.nextMatch = this.findNextMatch();
            return returnValue;
        }

        @Override
        public Iterator<Match<SearchData>> iterator() {
            return this;
        }

        private Match<SearchData> findNextMatch() {
            int preLength = this.byteSequence.getPreLength();
            while (this.matcher.find()) {
                int start = this.matcher.start() - preLength;
                int end = this.matcher.end() - preLength;
                if (start < 0) continue;
                if (start >= this.byteSequence.getLength()) {
                    return null;
                }
                return new Match<SearchData>(RegExByteMatcher.this.searchData, start, end - start);
            }
            return null;
        }
    }

    private class ByteCharSequence
    implements CharSequence {
        private ExtendedByteSequence byteSequence;
        private int preLength;

        ByteCharSequence(RegExByteMatcher regExByteMatcher, ExtendedByteSequence byteSequence) {
            this.byteSequence = byteSequence;
            this.preLength = byteSequence.getPreLength();
        }

        @Override
        public int length() {
            return this.byteSequence.getExtendedLength() + this.preLength;
        }

        @Override
        public char charAt(int index) {
            byte b = this.byteSequence.getByte(index - this.preLength);
            return (char)(b & 0xFF);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }
}

