/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import generic.theme.GIcon;
import ghidra.app.services.MarkerDescriptor;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.SearchConstants;
import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;

public class SearchMarkers {
    private static final Icon SEARCH_MARKER_ICON = new GIcon("icon.base.search.marker");
    private MarkerService service;
    private MarkerSet markerSet;
    private Program program;

    public SearchMarkers(PluginTool tool, String title, Program program) {
        this.program = program;
        this.service = (MarkerService)tool.getService(MarkerService.class);
        if (this.service == null) {
            return;
        }
    }

    private MarkerSet createMarkerSet(String title) {
        MarkerSet markers = this.service.createPointMarker(title, "Search", this.program, 75, true, true, false, (Color)SearchConstants.SEARCH_HIGHLIGHT_COLOR, SEARCH_MARKER_ICON);
        markers.setMarkerDescriptor(new MarkerDescriptor(){

            @Override
            public ProgramLocation getProgramLocation(MarkerLocation loc) {
                return new BytesFieldLocation(SearchMarkers.this.program, loc.getAddr());
            }
        });
        this.service.removeMarker(markers, this.program);
        return markers;
    }

    void makeActiveMarkerSet() {
        if (this.service == null || this.markerSet == null) {
            return;
        }
        this.service.setMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program);
    }

    void loadMarkers(String title, List<MemoryMatch<SearchData>> matches) {
        if (this.service == null) {
            return;
        }
        if (matches.isEmpty()) {
            this.deleteMarkerSet();
            return;
        }
        if (this.markerSet != null && !this.markerSet.getName().equals(title)) {
            this.deleteMarkerSet();
        }
        if (this.markerSet == null) {
            this.markerSet = this.createMarkerSet(title);
        }
        this.markerSet.clearAll();
        for (MemoryMatch<SearchData> match : matches) {
            this.markerSet.add(match.getAddress());
        }
        this.service.setMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program);
    }

    private void deleteMarkerSet() {
        if (this.markerSet != null) {
            this.markerSet.clearAll();
            this.service.removeMarker(this.markerSet, this.program);
            this.markerSet = null;
        }
    }

    public void dispose() {
        this.deleteMarkerSet();
        this.program = null;
    }
}

