/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MemorySearchService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.query.TableService;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.gui.MemorySearchOptions;
import ghidra.features.base.memsearch.gui.MemorySearchProvider;
import ghidra.features.base.memsearch.gui.SearchHistory;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.matcher.UserInputByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import javax.swing.KeyStroke;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Search bytes in memory", description="This plugin searches bytes in memory. The search is based on a value entered as hex or decimal numbers, or strings. The value may contain \"wildcards\" or regular expressions that will match any byte or nibble.", servicesRequired={ProgramManager.class, GoToService.class, TableService.class, CodeViewerService.class}, servicesProvided={MemorySearchService.class}, eventsConsumed={ProgramSelectionPluginEvent.class})
public class MemorySearchPlugin
extends Plugin
implements MemorySearchService {
    private static final int MAX_HISTORY = 10;
    private static final String SHOW_OPTIONS_PANEL = "Show Options Panel";
    private static final String SHOW_SCAN_PANEL = "Show Scan Panel";
    private UserInputByteMatcher lastByteMatcher;
    private MemorySearchOptions options;
    private SearchHistory searchHistory = new SearchHistory(10);
    private Address lastSearchAddress;
    private boolean showScanPanel;
    private boolean showOptionsPanel;

    public MemorySearchPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.options = new MemorySearchOptions(tool);
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u5185\u5b58\u641c\u7d22", this.getName()).menuPath(new String[]{"\u641c\u7d22", "&\u5185\u5b58..."})).menuGroup("search", "a")).keyBinding("s")).description("\u641c\u7d22\u5185\u5b58\u5b57\u8282\u5e8f\u5217")).helpLocation(new HelpLocation("Search", "Memory Search"))).withContext(NavigatableActionContext.class, true).onAction(this::showSearchMemoryProvider).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u91cd\u590d\u5185\u5b58\u641c\u7d22\u5411\u524d", this.getName()).menuPath(new String[]{"\u641c\u7d22", "\u91cd\u590d\u641c\u7d22\u5411&\u524d"})).menuGroup("search", "b")).keyBinding(KeyStroke.getKeyStroke(114, 0))).description("\u91cd\u590d\u4e0a\u6b21\u5185\u5b58\u641c\u7d22\u5411\u524d")).helpLocation(new HelpLocation("Search", "Repeat Search Forwards"))).withContext(NavigatableActionContext.class, true).enabledWhen(c -> this.lastByteMatcher != null && c.getAddress() != null).onAction(c -> this.searchOnce((NavigatableActionContext)c, true)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u91cd\u590d\u5185\u5b58\u641c\u7d22\u5411\u540e", this.getName()).menuPath(new String[]{"\u641c\u7d22", "\u91cd\u590d\u641c\u7d22\u5411&\u540e"})).menuGroup("search", "c")).keyBinding(KeyStroke.getKeyStroke(114, 64))).description("\u91cd\u590d\u4e0a\u6b21\u5185\u5b58\u641c\u7d22\u5411\u540e")).helpLocation(new HelpLocation("Search", "Repeat Search Backwards"))).withContext(NavigatableActionContext.class, true).enabledWhen(c -> this.lastByteMatcher != null && c.getAddress() != null).onAction(c -> this.searchOnce((NavigatableActionContext)c, false)).buildAndInstall((Tool)this.tool);
    }

    private void showSearchMemoryProvider(NavigatableActionContext c) {
        SearchSettings settings = this.lastByteMatcher != null ? this.lastByteMatcher.getSettings() : null;
        SearchHistory copy = new SearchHistory(this.searchHistory);
        MemorySearchProvider provider = new MemorySearchProvider(this, c.getNavigatable(), settings, this.options, copy);
        provider.showOptions(this.showOptionsPanel);
        provider.showScanPanel(this.showScanPanel);
    }

    private void searchOnce(NavigatableActionContext c, boolean forward) {
        SearchOnceTask task = new SearchOnceTask(c.getNavigatable(), forward);
        TaskLauncher.launch((Task)task);
    }

    void updateByteMatcher(UserInputByteMatcher matcher) {
        this.lastByteMatcher = matcher;
        this.searchHistory.addSearch(matcher);
    }

    public void readConfigState(SaveState saveState) {
        this.showOptionsPanel = saveState.getBoolean(SHOW_OPTIONS_PANEL, false);
        this.showScanPanel = saveState.getBoolean(SHOW_SCAN_PANEL, false);
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putBoolean(SHOW_OPTIONS_PANEL, this.showOptionsPanel);
        saveState.putBoolean(SHOW_SCAN_PANEL, this.showOptionsPanel);
    }

    @Override
    public void createMemorySearchProvider(Navigatable navigatable, String input, SearchSettings settings, boolean useSelection) {
        SearchHistory copy = new SearchHistory(this.searchHistory);
        MemorySearchProvider provider = new MemorySearchProvider(this, navigatable, settings, this.options, copy);
        provider.setSearchInput(input);
        provider.setSearchSelectionOnly(false);
        provider.setPrivate();
    }

    public void setShowOptionsPanel(boolean show) {
        this.showOptionsPanel = show;
    }

    public void setShowScanPanel(boolean show) {
        this.showScanPanel = show;
    }

    private class SearchOnceTask
    extends Task {
        private Navigatable navigatable;
        private boolean forward;

        public SearchOnceTask(Navigatable navigatable, boolean forward) {
            super("Search Next", true, true, true);
            this.navigatable = navigatable;
            this.forward = forward;
        }

        private AddressSet getSearchAddresses() {
            SearchSettings settings = MemorySearchPlugin.this.lastByteMatcher.getSettings();
            AddressSet searchAddresses = settings.getSearchAddresses(this.navigatable.getProgram());
            ProgramSelection selection = this.navigatable.getSelection();
            if (selection != null && !selection.isEmpty()) {
                searchAddresses = searchAddresses.intersect((AddressSetView)this.navigatable.getSelection());
            }
            return searchAddresses;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            AddressableByteSource source = this.navigatable.getByteSource();
            AddressSet addresses = this.getSearchAddresses();
            if (addresses.isEmpty()) {
                Msg.showWarn((Object)((Object)this), null, (String)"Search Failed!", (Object)"Addresses to search is empty!");
                return;
            }
            Address start = this.getSearchStartAddress();
            if (start == null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Search Failed!", (Object)"No valid start address!");
                return;
            }
            MemorySearcher<SearchData> searcher = new MemorySearcher<SearchData>(source, MemorySearchPlugin.this.lastByteMatcher, (AddressSetView)addresses, 1);
            MemoryMatch<SearchData> match = searcher.findOnce(start, this.forward, monitor);
            Swing.runLater(() -> this.navigateToMatch(match));
        }

        private Address getSearchStartAddress() {
            CodeUnit cu;
            ProgramLocation location = this.navigatable.getLocation();
            if (location == null) {
                return null;
            }
            Address start = this.navigatable.getLocation().getByteAddress();
            if (MemorySearchPlugin.this.lastSearchAddress != null && (cu = this.navigatable.getProgram().getListing().getCodeUnitContaining(start)) != null && cu.contains(MemorySearchPlugin.this.lastSearchAddress)) {
                start = MemorySearchPlugin.this.lastSearchAddress;
            }
            return this.forward ? start.next() : start.previous();
        }

        private void navigateToMatch(MemoryMatch<SearchData> match) {
            if (match != null) {
                MemorySearchPlugin.this.lastSearchAddress = match.getAddress();
                Program program = this.navigatable.getProgram();
                GoToService service = (GoToService)MemorySearchPlugin.this.tool.getService(GoToService.class);
                service.goTo(this.navigatable, (ProgramLocation)new BytesFieldLocation(program, match.getAddress()), program);
            } else {
                Msg.showWarn((Object)((Object)this), null, (String)"Match Not Found", (Object)("No match found going forward for " + MemorySearchPlugin.this.lastByteMatcher.getInput()));
            }
        }
    }
}

