/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.MaskedByteSequenceByteMatcher;
import ghidra.features.base.memsearch.matcher.UserInputByteMatcher;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class BinarySearchFormat
extends SearchFormat {
    private static final String VALID_CHARS = "01x?.";
    private static final int MAX_GROUP_SIZE = 8;

    BinarySearchFormat() {
        super("Binary");
    }

    @Override
    public UserInputByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        List<String> byteGroups = this.getByteGroups(input);
        if (this.hasInvalidChars(byteGroups)) {
            return new InvalidByteMatcher("Invalid character");
        }
        if (this.checkGroupSize(byteGroups)) {
            return new InvalidByteMatcher("Max group size exceeded. Enter <space> to add more.");
        }
        byte[] bytes = this.getBytes(byteGroups);
        byte[] masks = this.getMask(byteGroups);
        return new MaskedByteSequenceByteMatcher(input, bytes, masks, settings);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret value as a sequence of binary digits.\nSpaces will start the next byte.  Bit sequences less\nthan 8 bits are padded with 0's to the left. \nEnter 'x', '.' or '?' for a wildcard bit");
    }

    private boolean checkGroupSize(List<String> byteGroups) {
        for (String byteGroup : byteGroups) {
            if (byteGroup.length() <= 8) continue;
            return true;
        }
        return false;
    }

    private List<String> getByteGroups(String input) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private boolean hasInvalidChars(List<String> byteGroups) {
        for (String byteGroup : byteGroups) {
            if (!this.hasInvalidChars(byteGroup)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInvalidChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (VALID_CHARS.indexOf(string.charAt(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private byte getByte(String token) {
        byte b = 0;
        for (int i = 0; i < token.length(); ++i) {
            b = (byte)(b << 1);
            char c = token.charAt(i);
            if (c != '1') continue;
            b = (byte)(b | 1);
        }
        return b;
    }

    private byte getMask(String token) {
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            b = (byte)(b << 1);
            if (i < token.length()) {
                char c = token.charAt(i);
                if (c != '1' && c != '0') continue;
                b = (byte)(b | 1);
                continue;
            }
            b = (byte)(b | 1);
        }
        return b;
    }

    private byte[] getBytes(List<String> byteGroups) {
        byte[] bytes = new byte[byteGroups.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.getByte(byteGroups.get(i));
        }
        return bytes;
    }

    private byte[] getMask(List<String> byteGroups) {
        byte[] masks = new byte[byteGroups.size()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = this.getMask(byteGroups.get(i));
        }
        return masks;
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        UserInputByteMatcher byteMatcher;
        SearchFormat oldFormat = oldSettings.getSearchFormat();
        if (oldFormat.getFormatType() != SearchFormat.SearchFormatType.STRING_TYPE && (byteMatcher = oldFormat.parse(text, oldSettings)) instanceof MaskedByteSequenceByteMatcher) {
            MaskedByteSequenceByteMatcher matcher = (MaskedByteSequenceByteMatcher)byteMatcher;
            byte[] bytes = matcher.getBytes();
            byte[] mask = matcher.getMask();
            return this.getMaskedInputString(bytes, mask);
        }
        return this.isValidText(text, newSettings) ? text : "";
    }

    private String getMaskedInputString(byte[] bytes, byte[] masks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            for (int shift = 7; shift >= 0; --shift) {
                int bit = bytes[i] >> shift & 1;
                int maskBit = masks[i] >> shift & 1;
                builder.append(maskBit == 0 ? Character.valueOf('.') : Integer.toString(bit));
            }
            builder.append(" ");
        }
        return builder.toString().trim();
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.BYTE;
    }
}

