/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.combiner;

import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public enum Combiner {
    REPLACE("New", Combiner::replace),
    UNION("Add To", Combiner::union),
    INTERSECT("Intersect", Combiner::intersect),
    XOR("Xor", Combiner::xor),
    A_MINUS_B("A-B", Combiner::subtract),
    B_MINUS_A("B-A", Combiner::reverseSubtract);

    private String name;
    private BiFunction<List<MemoryMatch<SearchData>>, List<MemoryMatch<SearchData>>, Collection<MemoryMatch<SearchData>>> function;

    private Combiner(String name, BiFunction<List<MemoryMatch<SearchData>>, List<MemoryMatch<SearchData>>, Collection<MemoryMatch<SearchData>>> function) {
        this.name = name;
        this.function = function;
    }

    public boolean isMerge() {
        return this != REPLACE;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MemoryMatch<SearchData>> combine(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        return this.function.apply(matches1, matches2);
    }

    private static Collection<MemoryMatch<SearchData>> replace(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        return matches2;
    }

    private static Collection<MemoryMatch<SearchData>> union(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        Map<Address, MemoryMatch<SearchData>> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch<SearchData> match2 : matches2) {
            Address address = match2.getAddress();
            MemoryMatch<SearchData> match1 = matches1Map.get(address);
            if (match1 != null && match2.getLength() <= match1.getLength()) continue;
            matches1Map.put(address, match2);
        }
        return matches1Map.values();
    }

    private static Collection<MemoryMatch<SearchData>> intersect(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        ArrayList<MemoryMatch<SearchData>> intersection = new ArrayList<MemoryMatch<SearchData>>();
        Map<Address, MemoryMatch<SearchData>> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch<SearchData> match2 : matches2) {
            Address address = match2.getAddress();
            MemoryMatch<SearchData> match1 = matches1Map.get(address);
            if (match1 == null) continue;
            MemoryMatch<SearchData> best = match2.getLength() > match1.getLength() ? match2 : match1;
            intersection.add(best);
        }
        return intersection;
    }

    private static List<MemoryMatch<SearchData>> xor(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        ArrayList<MemoryMatch<SearchData>> results = new ArrayList<MemoryMatch<SearchData>>();
        results.addAll(Combiner.subtract(matches1, matches2));
        results.addAll(Combiner.subtract(matches2, matches1));
        return results;
    }

    private static Collection<MemoryMatch<SearchData>> subtract(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        Map<Address, MemoryMatch<SearchData>> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch<SearchData> match2 : matches2) {
            Address address = match2.getAddress();
            matches1Map.remove(address);
        }
        return matches1Map.values();
    }

    private static Collection<MemoryMatch<SearchData>> reverseSubtract(List<MemoryMatch<SearchData>> matches1, List<MemoryMatch<SearchData>> matches2) {
        return Combiner.subtract(matches2, matches1);
    }

    private static Map<Address, MemoryMatch<SearchData>> createMap(List<MemoryMatch<SearchData>> matches) {
        HashMap<Address, MemoryMatch<SearchData>> map = new HashMap<Address, MemoryMatch<SearchData>>();
        for (MemoryMatch<SearchData> result : matches) {
            map.put(result.getAddress(), result);
        }
        return map;
    }
}

