/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.app.util.viewer.util.OpenCloseManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.util.VoidPropertyMap;

public class PersistentOpenCloseManager
implements OpenCloseManager {
    private boolean openByDefault = true;
    private VoidPropertyMap booleanProperty;
    private ProgramUserData programUserData;
    private Address cachedAddress;
    private boolean cachedResult;
    private String defaultOpenClosePropertyname;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentOpenCloseManager(ProgramUserData data, String owner, String propertyName) {
        this.defaultOpenClosePropertyname = propertyName + "Default";
        this.programUserData = data;
        int tx = this.programUserData.startTransaction();
        try {
            this.booleanProperty = this.programUserData.getBooleanProperty(owner, propertyName, true);
        }
        finally {
            this.programUserData.endTransaction(tx);
        }
        String functionState = this.programUserData.getStringProperty(this.defaultOpenClosePropertyname, "Open");
        this.openByDefault = functionState.equals("Open");
    }

    @Override
    public boolean isOpen(Address address) {
        if (address.equals((Object)this.cachedAddress)) {
            return this.cachedResult;
        }
        this.cachedAddress = address;
        boolean contains = this.booleanProperty.hasProperty(address);
        this.cachedResult = this.openByDefault ? !contains : contains;
        return this.cachedResult;
    }

    @Override
    public void open(Address address) {
        this.cachedAddress = null;
        if (this.openByDefault) {
            this.removeAddressProperty(address);
        } else {
            this.addAddressProperty(address);
        }
    }

    @Override
    public void close(Address address) {
        this.cachedAddress = null;
        if (this.openByDefault) {
            this.addAddressProperty(address);
        } else {
            this.removeAddressProperty(address);
        }
    }

    @Override
    public boolean isOpenByDefault() {
        return this.openByDefault;
    }

    @Override
    public void openAll() {
        this.cachedAddress = null;
        this.openByDefault = true;
        this.clearProperties();
        this.programUserData.setStringProperty(this.defaultOpenClosePropertyname, "Open");
    }

    @Override
    public void closeAll() {
        this.cachedAddress = null;
        this.openByDefault = false;
        this.clearProperties();
        this.programUserData.setStringProperty(this.defaultOpenClosePropertyname, "Closed");
    }

    private void addAddressProperty(Address address) {
        int tx = this.programUserData.startTransaction();
        try {
            this.booleanProperty.add(address);
        }
        finally {
            this.programUserData.endTransaction(tx);
        }
    }

    private void removeAddressProperty(Address address) {
        int tx = this.programUserData.startTransaction();
        try {
            this.booleanProperty.remove(address);
        }
        finally {
            this.programUserData.endTransaction(tx);
        }
    }

    private void clearProperties() {
        int tx = this.programUserData.startTransaction();
        try {
            this.booleanProperty.clear();
        }
        finally {
            this.programUserData.endTransaction(tx);
        }
    }
}

