/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.options;

import generic.theme.Gui;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class ListingDisplayOptionsEditor
implements OptionsEditor {
    public static final String DEFAULT_FONT_ID = "font.listing.base";
    private OptionsGui optionsGui;
    private Options options;
    private PropertyChangeListener propertyChangeListener;

    public ListingDisplayOptionsEditor(Options options) {
        this.options = options;
        this.registerOptions();
    }

    public void dispose() {
        if (this.optionsGui != null) {
            this.optionsGui.setOptionsPropertyChangeListener(null);
        }
        this.propertyChangeListener = null;
    }

    private void registerOptions() {
        String prefix = "Sets the ";
        this.options.registerThemeFontBinding("BASE FONT", DEFAULT_FONT_ID, null, prefix + "BASE FONT");
        for (ScreenElement element : OptionsGui.elements) {
            String colorOptionName = element.getColorOptionName();
            this.options.registerThemeColorBinding(colorOptionName, element.getThemeColorId(), null, prefix + colorOptionName);
            String styleOptionName = element.getStyleOptionName();
            int style = element.getStyle();
            this.options.registerOption(styleOptionName, (Object)style, null, prefix + styleOptionName);
        }
    }

    public void apply() {
        if (this.optionsGui != null) {
            Font font = Gui.getFont((String)DEFAULT_FONT_ID);
            Font newFont = this.optionsGui.getBaseFont();
            if (!newFont.equals(font)) {
                this.options.setFont("BASE FONT", newFont);
            }
            for (ScreenElement element : OptionsGui.elements) {
                int guiStyle;
                int optionStyle;
                Color guiColor = element.getColor();
                Color optionColor = this.options.getColor(element.getColorOptionName(), (Color)element.getDefaultColor());
                if (!optionColor.equals(guiColor)) {
                    this.options.setColor(element.getColorOptionName(), guiColor);
                }
                if ((optionStyle = this.options.getInt(element.getStyleOptionName(), -1)) == (guiStyle = element.getStyle())) continue;
                this.options.setInt(element.getStyleOptionName(), guiStyle);
            }
        }
    }

    public void cancel() {
    }

    public void reload() {
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
        if (this.optionsGui != null) {
            this.optionsGui.setOptionsPropertyChangeListener(listener);
        }
    }

    public boolean isResizable() {
        return true;
    }

    public JComponent getEditorComponent(Options editableOptions, EditorStateFactory editorStateFactory) {
        Font font = Gui.getFont((String)DEFAULT_FONT_ID);
        for (ScreenElement element : OptionsGui.elements) {
            Color c = this.options.getColor(element.getColorOptionName(), (Color)element.getDefaultColor());
            int style = this.options.getInt(element.getStyleOptionName(), -1);
            element.setColor(c);
            element.setStyle(style);
        }
        this.optionsGui = new OptionsGui(font, this.propertyChangeListener);
        return this.optionsGui;
    }
}

