/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.action.DockingActionIf;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldDescriptionProvider;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.FieldSelectionHelper;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.LayeredColorModel;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.ListingMarginProviderService;
import ghidra.app.services.ListingOverviewProviderService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingFieldDescriptionProvider;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingHoverProvider;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelAdapter;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.app.util.viewer.listingpanel.ProgramBigListingModel;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.listingpanel.ProgramSelectionListener;
import ghidra.app.util.viewer.listingpanel.PropertyBasedBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.StringSelectionListener;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.app.util.viewer.util.ScrollpaneAlignedHorizontalLayout;
import ghidra.app.util.viewer.util.ScrollpanelResizeablePanelLayout;
import ghidra.app.util.viewer.util.VerticalPixelAddressMapImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.ImmutableAddressSet;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.CollapsedCodeLocation;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.layout.HorizontalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ListingPanel
extends JPanel
implements FieldMouseListener,
FieldLocationListener,
FieldSelectionListener,
LayoutListener {
    public static final int DEFAULT_DIVIDER_LOCATION = 70;
    private static final Icon CURSOR_LOC_ICON = new GIcon("icon.plugin.codebrowser.cursor.location");
    private FormatManager formatManager;
    private ListingModelAdapter layoutModel;
    private FieldPanel fieldPanel;
    private IndexedScrollPane scroller;
    private JSplitPane splitPane;
    private int splitPaneDividerLocation = 70;
    private FocusingMouseListener focusingMouseListener = new FocusingMouseListener();
    private ProgramLocationListener programLocationListener;
    private ProgramSelectionListener programSelectionListener;
    private ProgramSelectionListener liveProgramSelectionListener;
    private StringSelectionListener stringSelectionListener;
    private FieldSelectionListener fieldPanelLiveSelectionListener = (selection, trigger) -> {
        if (this.liveProgramSelectionListener == null) {
            return;
        }
        ProgramSelection ps = this.layoutModel.getProgramSelection(selection);
        if (ps != null) {
            this.liveProgramSelectionListener.programSelectionChanged(ps, trigger);
        }
    };
    private ListingModel listingModel;
    private FieldHeader headerPanel;
    private List<ButtonPressedListener> buttonListeners = new ArrayList<ButtonPressedListener>();
    private List<ChangeListener> indexMapChangeListeners = new ArrayList<ChangeListener>();
    private ListingHoverProvider listingHoverHandler;
    private List<ListingMarginProvider> marginProviders = new ArrayList<ListingMarginProvider>();
    private List<ListingOverviewProvider> overviewProviders = new ArrayList<ListingOverviewProvider>();
    private String currentTextSelection;
    private boolean useMarkerNameSuffix;
    private UniversalID marginOwnerId = UniversalIdGenerator.nextID();
    private ChangeListener markerChangeListener;
    private MarkerService markerService;
    private Color cursorLineHighlightColor;
    private boolean isHighlightCursorLineEnabled;
    private MarkerSet selectionMarkers;
    private MarkerSet highlightMarkers;
    private MarkerSet cursorMarkers;
    private VerticalPixelAddressMapImpl pixmap;
    private PropertyBasedBackgroundColorModel propertyBasedColorModel;
    private LayeredColorModel layeredColorModel;
    private LayoutModelListener layoutModelListener = new LayoutModelListener(){

        public void modelSizeChanged(IndexMapper mapper) {
            ListingPanel.this.updateProviders();
        }

        public void dataChanged(BigInteger start, BigInteger end) {
        }
    };
    private List<AddressSetDisplayListener> displayListeners = new ArrayList<AddressSetDisplayListener>();

    public ListingPanel(FormatManager manager) {
        super(new BorderLayout());
        this.formatManager = manager;
        this.layoutModel = this.createLayoutModel(null);
        this.fieldPanel = this.createFieldPanel(this.layoutModel);
        this.fieldPanel.addFieldMouseListener((FieldMouseListener)this);
        this.fieldPanel.addFieldLocationListener((FieldLocationListener)this);
        this.fieldPanel.addFieldSelectionListener((FieldSelectionListener)this);
        this.fieldPanel.addLiveFieldSelectionListener(this.fieldPanelLiveSelectionListener);
        this.fieldPanel.addLayoutListener((LayoutListener)this);
        this.propertyBasedColorModel = new PropertyBasedBackgroundColorModel();
        this.fieldPanel.setBackgroundColorModel((BackgroundColorModel)this.propertyBasedColorModel);
        this.scroller = new IndexedScrollPane((JComponent)this.fieldPanel);
        this.listingHoverHandler = new ListingHoverProvider();
        this.add((Component)this.scroller, "Center");
        this.fieldPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (ListingMarginProvider provider : ListingPanel.this.marginProviders) {
                    provider.getComponent().invalidate();
                }
                ListingPanel.this.validate();
            }
        });
        String viewName = "Assembly Listing View";
        this.fieldPanel.setName(viewName);
        this.fieldPanel.getAccessibleContext().setAccessibleName(viewName);
        this.markerChangeListener = new MarkerChangeListener();
    }

    public ListingPanel(FormatManager mgr, Program program) {
        this(mgr);
        this.setProgram(program);
    }

    public ListingPanel(FormatManager mgr, ListingModel model) {
        this(mgr);
        this.setListingModel(model);
        this.listingHoverHandler.setProgram(model.getProgram());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(preferredSize.width, this.getNewWindowDefaultWidth());
        return preferredSize;
    }

    protected int getNewWindowDefaultWidth() {
        return 500;
    }

    protected FieldPanel createFieldPanel(LayoutModel model) {
        FieldPanel fp = new FieldPanel(model, "Listing");
        fp.setFieldDescriptionProvider((FieldDescriptionProvider)new ListingFieldDescriptionProvider());
        return fp;
    }

    protected ListingModel createListingModel(Program program) {
        if (program == null) {
            return null;
        }
        return new ProgramBigListingModel(program, this.formatManager);
    }

    protected ListingModelAdapter createLayoutModel(ListingModel model) {
        ListingModelAdapter modelAdapter = new ListingModelAdapter(model);
        modelAdapter.addLayoutModelListener(this.layoutModelListener);
        return modelAdapter;
    }

    public void setProgramLocationListener(ProgramLocationListener listener) {
        this.programLocationListener = listener;
    }

    public void setProgramSelectionListener(ProgramSelectionListener listener) {
        this.programSelectionListener = listener;
    }

    public void setLiveProgramSelectionListener(ProgramSelectionListener listener) {
        this.liveProgramSelectionListener = listener;
    }

    public void setStringSelectionListener(StringSelectionListener listener) {
        this.stringSelectionListener = listener;
    }

    public void setListingModel(ListingModel newModel) {
        this.layoutModel.dispose();
        this.listingModel = newModel;
        this.layoutModel = this.createLayoutModel(newModel);
        this.fieldPanel.setLayoutModel((LayoutModel)this.layoutModel);
        Swing.runLater(() -> this.updateProviders());
    }

    public ListingModel getListingModel() {
        return this.listingModel;
    }

    public void showHeader(boolean show) {
        if (show) {
            this.headerPanel = new FieldHeader(this.formatManager, this.scroller, this.fieldPanel);
            Field f = this.fieldPanel.getCurrentField();
            if (f instanceof ListingField) {
                ListingField currentField = (ListingField)f;
                this.headerPanel.setSelectedFieldFactory(currentField.getFieldFactory());
            }
        } else {
            this.headerPanel.setViewComponent(null);
            this.headerPanel = null;
        }
        this.buildPanels();
    }

    public List<DockingActionIf> getHeaderActions(String ownerName) {
        if (this.headerPanel != null) {
            return this.headerPanel.getActions(ownerName);
        }
        return null;
    }

    public boolean isHeaderShowing() {
        return this.headerPanel != null;
    }

    private void updateProviders() {
        AddressIndexMap addressIndexMap = this.layoutModel.getAddressIndexMap();
        for (ListingMarginProvider listingMarginProvider : this.marginProviders) {
            listingMarginProvider.screenDataChanged(this, addressIndexMap, this.pixmap);
        }
        for (ListingOverviewProvider listingOverviewProvider : this.overviewProviders) {
            listingOverviewProvider.screenDataChanged(this.getProgram(), addressIndexMap);
        }
        for (ChangeListener changeListener : this.indexMapChangeListeners) {
            changeListener.stateChanged(null);
        }
        if (this.layeredColorModel != null) {
            this.layeredColorModel.modelDataChanged(this);
        } else {
            this.propertyBasedColorModel.modelDataChanged(this);
        }
    }

    public FieldHeader getFieldHeader() {
        return this.headerPanel;
    }

    public void updateDisplay(boolean updateImmediately) {
        this.layoutModel.dataChanged(updateImmediately);
    }

    public void removeMarginService(ListingMarginProviderService service) {
        for (ListingMarginProvider provider : this.marginProviders) {
            if (!service.isOwner(provider)) continue;
            this.removeMarginProvider(provider);
            provider.dispose();
            return;
        }
    }

    public void addMarginService(ListingMarginProviderService service, boolean isConnected) {
        if (this.containsMarginProviver(service)) {
            return;
        }
        ListingMarginProvider provider = service.createMarginProvider();
        provider.setOwnerId(this.marginOwnerId);
        this.addMarginProvider(provider);
    }

    private boolean containsMarginProviver(ListingMarginProviderService service) {
        for (ListingMarginProvider provider : this.marginProviders) {
            if (!service.isOwner(provider)) continue;
            return true;
        }
        return false;
    }

    public void removeOverviewService(ListingOverviewProviderService service) {
        for (ListingOverviewProvider provider : this.overviewProviders) {
            if (!service.isOwner(provider)) continue;
            this.removeOverviewProvider(provider);
            provider.dispose();
            return;
        }
    }

    public void addOverviewService(ListingOverviewProviderService service, Navigatable navigatable, boolean connected) {
        if (this.containsOverviewProvider(service)) {
            return;
        }
        ListingOverviewProvider provider = service.createOverviewProvider();
        provider.setNavigatable(navigatable);
        this.addOverviewProvider(provider);
    }

    private boolean containsOverviewProvider(ListingOverviewProviderService service) {
        for (ListingOverviewProvider provider : this.overviewProviders) {
            if (!service.isOwner(provider)) continue;
            return true;
        }
        return false;
    }

    public void removeMarginProvider(ListingMarginProvider provider) {
        JComponent component = provider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.marginProviders.remove(provider);
        this.buildPanels();
    }

    public void addMarginProvider(ListingMarginProvider provider) {
        JComponent component = provider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        if (provider.isResizeable()) {
            this.marginProviders.add(0, provider);
        } else {
            this.marginProviders.add(provider);
        }
        provider.screenDataChanged(this, this.layoutModel.getAddressIndexMap(), this.pixmap);
        this.buildPanels();
    }

    private void buildPanels() {
        boolean fieldPanelHasFocus = this.fieldPanel.hasFocus();
        this.removeAll();
        this.add((Component)this.buildLeftComponent(), "West");
        this.add((Component)this.buildCenterComponent(), "Center");
        JComponent overviewComponent = this.buildOverviewComponent();
        if (overviewComponent != null) {
            this.scroller.setScrollbarSideKickComponent(this.buildOverviewComponent());
        }
        this.revalidate();
        this.repaint();
        if (fieldPanelHasFocus) {
            this.fieldPanel.requestFocusInWindow();
        }
    }

    private JComponent buildOverviewComponent() {
        if (this.overviewProviders.isEmpty()) {
            return null;
        }
        JPanel rightPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        for (ListingOverviewProvider overviewProvider : this.overviewProviders) {
            rightPanel.add(overviewProvider.getComponent());
        }
        return rightPanel;
    }

    private JComponent buildLeftComponent() {
        List<ListingMarginProvider> marginProviderList = this.getNonResizeableMarginProviders();
        JPanel leftPanel = new JPanel(new ScrollpaneAlignedHorizontalLayout(this.scroller));
        for (ListingMarginProvider marginProvider : marginProviderList) {
            leftPanel.add(marginProvider.getComponent());
        }
        return leftPanel;
    }

    private List<ListingMarginProvider> getNonResizeableMarginProviders() {
        if (this.marginProviders.isEmpty()) {
            return this.marginProviders;
        }
        ListingMarginProvider firstMarginProvider = this.marginProviders.get(0);
        if (firstMarginProvider.isResizeable()) {
            return this.marginProviders.subList(1, this.marginProviders.size());
        }
        return this.marginProviders;
    }

    private JComponent buildCenterComponent() {
        Object centerComponent = this.scroller;
        ListingMarginProvider resizeableMarginProvider = this.getResizeableMarginProvider();
        if (resizeableMarginProvider != null) {
            if (this.splitPane != null) {
                this.splitPaneDividerLocation = this.splitPane.getDividerLocation();
            }
            JPanel resizeablePanel = new JPanel(new ScrollpanelResizeablePanelLayout(this.scroller));
            resizeablePanel.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            resizeablePanel.add(resizeableMarginProvider.getComponent());
            this.splitPane = new JSplitPane(1, resizeablePanel, (Component)this.scroller);
            this.splitPane.setDividerSize(4);
            this.splitPane.setDividerLocation(this.splitPaneDividerLocation);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setBorder(null);
            centerComponent = this.splitPane;
        }
        if (this.headerPanel != null) {
            this.headerPanel.setViewComponent((JComponent)centerComponent);
            centerComponent = this.headerPanel;
        }
        return centerComponent;
    }

    private ListingMarginProvider getResizeableMarginProvider() {
        if (this.marginProviders.isEmpty()) {
            return null;
        }
        ListingMarginProvider marginProvider = this.marginProviders.get(0);
        return marginProvider.isResizeable() ? marginProvider : null;
    }

    public void addIndexMapChangeListener(ChangeListener listener) {
        this.indexMapChangeListeners.add(listener);
    }

    public void removeIndexMapChangeListener(ChangeListener listener) {
        this.indexMapChangeListeners.remove(listener);
    }

    public void addOverviewProvider(ListingOverviewProvider provider) {
        JComponent component = provider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        this.overviewProviders.add(provider);
        provider.screenDataChanged(this.getProgram(), this.layoutModel.getAddressIndexMap());
        this.buildPanels();
    }

    public void removeOverviewProvider(ListingOverviewProvider provider) {
        JComponent component = provider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.overviewProviders.remove(provider);
        this.buildPanels();
    }

    public void addButtonPressedListener(ButtonPressedListener listener) {
        this.buttonListeners.add(listener);
    }

    public void removeButtonPressedListener(ButtonPressedListener listener) {
        this.buttonListeners.remove(listener);
    }

    public void removeHighlightProvider(ListingHighlightProvider highlightProvider) {
        this.formatManager.removeHighlightProvider(highlightProvider);
    }

    public void addHighlightProvider(ListingHighlightProvider highlightProvider) {
        this.formatManager.addHighlightProvider(highlightProvider);
    }

    public FieldPanel getFieldPanel() {
        return this.fieldPanel;
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        AddressIndexMap addrMap = this.layoutModel.getAddressIndexMap();
        this.pixmap = new VerticalPixelAddressMapImpl(layouts, addrMap);
        for (ListingMarginProvider provider : this.marginProviders) {
            provider.screenDataChanged(this, addrMap, this.pixmap);
        }
        for (AddressSetDisplayListener listener : this.displayListeners) {
            this.notifyDisplayListener(listener);
        }
    }

    private void notifyDisplayListener(AddressSetDisplayListener listener) {
        AddressSetView displayAddresses = this.pixmap.getAddressSet();
        try {
            listener.visibleAddressesChanged(displayAddresses);
        }
        catch (Throwable t) {
            Msg.showError((Object)this, (Component)this.fieldPanel, (String)"Error in Display Listener", (Object)"Exception encountered when notifying listeners of change in display", (Throwable)t);
        }
    }

    public int getDividerLocation() {
        if (this.splitPane != null) {
            return this.splitPane.getDividerLocation();
        }
        return this.splitPaneDividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.splitPaneDividerLocation = dividerLocation;
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(dividerLocation);
        }
    }

    public void setListingHoverHandler(ListingHoverProvider handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Cannot set the hover handler to null!");
        }
        if (this.listingHoverHandler != null) {
            if (this.listingHoverHandler.isShowing()) {
                this.listingHoverHandler.closeHover();
            }
            this.listingHoverHandler.initializeListingHoverHandler(handler);
            this.listingHoverHandler.dispose();
        }
        this.listingHoverHandler = handler;
        this.fieldPanel.setHoverProvider((HoverProvider)this.listingHoverHandler);
    }

    public void dispose() {
        if (this.listingModel != null) {
            this.listingModel.dispose();
            this.listingModel = null;
        }
        this.setListingModel(null);
        for (ListingMarginProvider provider : this.marginProviders) {
            provider.dispose();
        }
        this.removeAll();
        this.listingHoverHandler.dispose();
        this.layoutModel.dispose();
        this.layoutModel = this.createLayoutModel(null);
        this.layoutModel.dispose();
        this.buttonListeners.clear();
        this.fieldPanel.dispose();
    }

    public boolean goTo(ProgramLocation loc) {
        return this.goTo(loc, true);
    }

    public boolean goTo(ProgramLocation loc, boolean centerWhenNotVisible) {
        Swing.assertSwingThread((String)"goTo() must be called on the Swing thread");
        FieldLocation floc = this.getFieldLocation(loc);
        if (floc == null) {
            return false;
        }
        if (centerWhenNotVisible) {
            this.fieldPanel.goTo(floc.getIndex(), floc.getFieldNum(), floc.getRow(), floc.getCol(), false);
        } else {
            this.fieldPanel.setCursorPosition(floc.getIndex(), floc.getFieldNum(), floc.getRow(), floc.getCol());
            this.fieldPanel.scrollToCursor();
        }
        return true;
    }

    public void scrollTo(ProgramLocation location) {
        FieldLocation fieldLocation = this.getFieldLocation(location);
        if (fieldLocation == null) {
            return;
        }
        this.fieldPanel.scrollTo(fieldLocation);
    }

    public void center(ProgramLocation location) {
        FieldLocation fieldLocation = this.getFieldLocation(location);
        this.fieldPanel.center(fieldLocation);
    }

    private FieldLocation getFieldLocation(ProgramLocation loc) {
        Program program = this.getProgram();
        if (program == null) {
            return null;
        }
        this.openDataOrFunctionAsNeeded(loc);
        FieldLocation floc = this.layoutModel.getFieldLocation(loc);
        if (floc != null) {
            return floc;
        }
        Address address = loc.getAddress();
        AddressSpace locAddressSpace = address.getAddressSpace();
        AddressSpace programAddressSpace = program.getAddressFactory().getAddressSpace(locAddressSpace.getSpaceID());
        if (programAddressSpace != locAddressSpace) {
            FieldLocation compatibleLocation = this.getFieldLocationForDifferingAddressSpaces(loc, program);
            return compatibleLocation;
        }
        return this.layoutModel.getFieldLocation(new ProgramLocation(program, address));
    }

    private FieldLocation getFieldLocationForDifferingAddressSpaces(ProgramLocation loc, Program program) {
        Address address = DiffUtility.getCompatibleMemoryAddress(loc.getAddress(), program);
        if (address == null) {
            return null;
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            if (!cu.getMinAddress().equals((Object)address)) {
                return this.getFieldLocationForDataAndOpenAsNeeded(data, address);
            }
            if (!cu.getMinAddress().equals((Object)loc.getByteAddress())) {
                return this.getFieldLocationForDataAndOpenAsNeeded(data, loc.getByteAddress());
            }
        }
        return this.layoutModel.getFieldLocation(new ProgramLocation(program, address));
    }

    private void openDataOrFunctionAsNeeded(ProgramLocation location) {
        if (location instanceof CollapsedCodeLocation) {
            return;
        }
        Address address = location.getByteAddress();
        Program program = this.getProgram();
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            this.openData(data, address);
        } else if (cu instanceof Instruction) {
            Instruction instruction = (Instruction)cu;
            this.openFunction(instruction);
        }
    }

    private void openFunction(Instruction instruction) {
        Address address = instruction.getMinAddress();
        Program program = instruction.getProgram();
        Function function = program.getFunctionManager().getFunctionContaining(address);
        if (function == null) {
            return;
        }
        Address functionAddress = function.getEntryPoint();
        if (address.equals((Object)functionAddress)) {
            return;
        }
        if (!this.listingModel.isFunctionOpen(functionAddress)) {
            this.listingModel.setFunctionOpen(functionAddress, true);
        }
    }

    private void openData(Data data, Address address) {
        if (data.getComponent(0) == null) {
            return;
        }
        Data subData = data.getPrimitiveAt((int)address.subtract(data.getMinAddress()));
        if (subData == null) {
            return;
        }
        if (this.openAllData(subData)) {
            this.layoutModel.dataChanged(true);
        }
    }

    private FieldLocation getFieldLocationForDataAndOpenAsNeeded(Data data, Address address) {
        boolean didOpen;
        Data subData = data.getPrimitiveAt((int)address.subtract(data.getMinAddress()));
        if (subData != null && (didOpen = this.openAllData(subData))) {
            this.layoutModel.dataChanged(true);
        }
        while (subData != null) {
            Address addr = subData.getMinAddress();
            Program program = subData.getProgram();
            AddressFieldLocation location = new AddressFieldLocation(program, addr, subData.getComponentPath(), addr.toString(), 0);
            FieldLocation floc = this.layoutModel.getFieldLocation((ProgramLocation)location);
            if (floc != null) {
                return floc;
            }
            subData = subData.getParent();
        }
        return null;
    }

    private boolean openAllData(Data data) {
        boolean didOpen = false;
        while (data != null) {
            if (!this.listingModel.isOpen(data)) {
                didOpen |= this.listingModel.openData(data);
            }
            data = data.getParent();
        }
        return didOpen;
    }

    public boolean goTo(Address addr) {
        Program p = this.getProgram();
        if (p != null) {
            return this.goTo(new ProgramLocation(p, addr));
        }
        return false;
    }

    public boolean goTo(Address currentAddress, Address gotoAddress) {
        ProgramLocation loc;
        ReferenceManager refMgr;
        Reference ref;
        Program program = this.getProgram();
        if (program == null) {
            return false;
        }
        SymbolTable symTable = program.getSymbolTable();
        Symbol symbol = symTable.getSymbol(ref = (refMgr = program.getReferenceManager()).getReference(currentAddress, gotoAddress, 0));
        if (symbol != null && (loc = symbol.getProgramLocation()) != null) {
            return this.goTo(loc, true);
        }
        return this.goTo(gotoAddress);
    }

    public void buttonPressed(FieldLocation fieldLocation, Field field, MouseEvent mouseEvent) {
        if (fieldLocation == null || !(field instanceof ListingField)) {
            return;
        }
        ListingField listingField = (ListingField)field;
        ProgramLocation programLocation = this.layoutModel.getProgramLocation(fieldLocation, listingField);
        if (programLocation == null) {
            return;
        }
        for (ButtonPressedListener element : this.buttonListeners) {
            element.buttonPressed(programLocation, fieldLocation, listingField, mouseEvent);
        }
    }

    public void setProgram(Program program) {
        this.listingHoverHandler.setProgram(program);
        this.setListingModel(this.createListingModel(program));
    }

    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        ProgramLocation pLoc;
        if (!(field instanceof ListingField)) {
            return;
        }
        ListingField lf = (ListingField)field;
        if (this.isHeaderShowing()) {
            FieldFactory selectedFieldFactory = this.headerPanel.getSelectedFieldFactory();
            if (lf.getFieldFactory() != selectedFieldFactory) {
                this.headerPanel.setSelectedFieldFactory(lf.getFieldFactory());
                this.headerPanel.repaint();
            }
            this.headerPanel.setTabLock(false);
        }
        if ((pLoc = this.layoutModel.getProgramLocation(location, field)) == null) {
            return;
        }
        if (this.programLocationListener != null) {
            this.programLocationListener.programLocationChanged(pLoc, trigger);
        }
        this.setCursorMarkerAddress(pLoc.getAddress());
        for (ListingMarginProvider provider : this.marginProviders) {
            provider.setLocation(pLoc);
        }
    }

    public void setView(AddressSetView view) {
        AddressIndexMap currentMap;
        AddressSetView originalView;
        if ((view = ImmutableAddressSet.asImmutable((AddressSetView)view)).hasSameAddresses(originalView = (currentMap = this.layoutModel.getAddressIndexMap()).getOriginalAddressSet())) {
            return;
        }
        this.layoutModel.setAddressSet(view);
        this.updateProviders();
    }

    public AddressSetView getView() {
        AddressIndexMap map = this.layoutModel.getAddressIndexMap();
        return map.getOriginalAddressSet();
    }

    public void setBackgroundColorModel(ListingBackgroundColorModel colorModel) {
        if (colorModel == null) {
            this.fieldPanel.setBackgroundColorModel((BackgroundColorModel)this.propertyBasedColorModel);
            this.layeredColorModel = null;
        } else {
            colorModel.modelDataChanged(this);
            this.layeredColorModel = new LayeredColorModel(colorModel, this.propertyBasedColorModel);
            this.fieldPanel.setBackgroundColorModel((BackgroundColorModel)this.layeredColorModel);
        }
    }

    public void setTextBackgroundColor(Color c) {
        if (this.fieldPanel != null) {
            this.fieldPanel.setBackgroundColor(c);
        }
    }

    public Color getTextBackgroundColor() {
        if (this.fieldPanel != null) {
            return this.fieldPanel.getBackgroundColor();
        }
        return null;
    }

    public boolean isActive() {
        return this.fieldPanel.isFocused();
    }

    public ProgramLocation getProgramLocation() {
        FieldLocation loc = this.fieldPanel.getCursorLocation();
        if (loc == null) {
            return null;
        }
        Field field = this.fieldPanel.getCurrentField();
        return this.layoutModel.getProgramLocation(loc, field);
    }

    public ProgramLocation getProgramLocation(Point point) {
        FieldLocation dropLoc = new FieldLocation();
        Field field = this.fieldPanel.getFieldAt(point.x, point.y, dropLoc);
        if (field instanceof ListingField) {
            ListingField lf = (ListingField)field;
            return lf.getFieldFactory().getProgramLocation(dropLoc.getRow(), dropLoc.getCol(), lf);
        }
        return null;
    }

    public List<ListingMarginProvider> getMarginProviders() {
        return this.marginProviders;
    }

    public List<ListingOverviewProvider> getOverviewProviders() {
        return this.overviewProviders;
    }

    public boolean isStartDragOk() {
        return this.fieldPanel.isStartDragOK();
    }

    public void setCursorPosition(ProgramLocation loc) {
        this.setCursorPosition(loc, EventTrigger.API_CALL);
    }

    public void setCursorPosition(ProgramLocation loc, EventTrigger trigger) {
        FieldLocation floc = this.getFieldLocation(loc);
        if (floc != null) {
            this.fieldPanel.setCursorPosition(floc.getIndex(), floc.getFieldNum(), floc.getRow(), floc.getCol(), trigger);
        }
    }

    public ProgramLocation getCursorLocation() {
        FieldLocation cursorPosition = this.fieldPanel.getCursorLocation();
        if (cursorPosition == null) {
            return null;
        }
        return this.layoutModel.getProgramLocation(cursorPosition, this.fieldPanel.getCurrentField());
    }

    public Point getCursorPoint() {
        return this.fieldPanel.getCursorPoint();
    }

    public Rectangle getCursorBounds() {
        return this.fieldPanel.getCursorBounds();
    }

    public AddressIndexMap getAddressIndexMap() {
        return this.layoutModel.getAddressIndexMap();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scroller.getVerticalScrollBar();
    }

    public FormatManager getFormatManager() {
        return this.formatManager;
    }

    public Layout getLayout(Address addr) {
        return this.layoutModel.getLayout(addr);
    }

    public void addHoverService(ListingHoverService hoverService) {
        this.listingHoverHandler.addHoverService(hoverService);
    }

    public void removeHoverService(ListingHoverService hoverService) {
        this.listingHoverHandler.removeHoverService(hoverService);
    }

    public void setHoverMode(boolean enabled) {
        this.listingHoverHandler.setHoverEnabled(enabled);
        if (enabled) {
            this.fieldPanel.setHoverProvider((HoverProvider)this.listingHoverHandler);
        } else {
            this.fieldPanel.setHoverProvider(null);
        }
    }

    public boolean isHoverShowing() {
        return this.listingHoverHandler.isShowing();
    }

    public Program getProgram() {
        if (this.listingModel != null) {
            return this.listingModel.getProgram();
        }
        return null;
    }

    public ProgramSelection getProgramSelection() {
        return this.layoutModel.getProgramSelection(this.fieldPanel.getSelection());
    }

    public ProgramSelection getProgramSelection(FieldSelection fieldSelection) {
        return this.layoutModel.getProgramSelection(fieldSelection);
    }

    public void selectAll() {
        this.fieldPanel.requestFocus();
        ProgramSelection sel = this.layoutModel.getAllProgramSelection();
        this.setSelection(sel);
    }

    public AddressSet selectComplement() {
        this.fieldPanel.requestFocus();
        AddressIndexMap addrIndexMap = this.layoutModel.getAddressIndexMap();
        AddressSetView viewSet = addrIndexMap.getOriginalAddressSet();
        AddressSet selectionSet = addrIndexMap.getAddressSet(this.fieldPanel.getSelection());
        AddressSet complementSet = viewSet.subtract((AddressSetView)selectionSet);
        this.fieldPanel.setSelection(addrIndexMap.getFieldSelection((AddressSetView)complementSet));
        return complementSet;
    }

    public void setSelection(ProgramSelection sel) {
        this.setSelection(sel, EventTrigger.API_CALL);
    }

    public void setSelection(ProgramSelection sel, EventTrigger trigger) {
        Program program = this.getProgram();
        MarkerSet markers = this.getSelectionMarkers(program);
        if (sel == null) {
            this.fieldPanel.setSelection(this.layoutModel.getFieldSelection(null), trigger);
            if (markers != null) {
                markers.clearAll();
            }
            return;
        }
        InteriorSelection interior = sel.getInteriorSelection();
        if (interior != null) {
            FieldLocation loc1 = this.layoutModel.getFieldLocation(interior.getFrom());
            FieldLocation loc2 = this.layoutModel.getFieldLocation(interior.getTo());
            if (loc1 != null && loc2 != null) {
                FieldSelection fieldSel = new FieldSelection();
                int fieldNum1 = -1;
                Layout layout = this.layoutModel.getLayout(loc1.getIndex());
                if (layout != null) {
                    fieldNum1 = layout.getBeginRowFieldNum(loc1.getFieldNum());
                }
                Layout layout2 = this.layoutModel.getLayout(loc2.getIndex());
                if (fieldNum1 >= 0 && layout2 != null) {
                    BigInteger index2 = loc2.getIndex();
                    int fieldNum2 = layout.getEndRowFieldNum(loc2.getFieldNum());
                    if (fieldNum2 >= layout2.getNumFields()) {
                        index2 = loc2.getIndex().add(BigInteger.ONE);
                        fieldNum2 = 0;
                    }
                    fieldSel.addRange(new FieldLocation(loc1.getIndex(), fieldNum1, 0, 0), new FieldLocation(index2, fieldNum2, 0, 0));
                    this.fieldPanel.setSelection(fieldSel, trigger);
                    return;
                }
            }
        }
        this.fieldPanel.setSelection(this.layoutModel.getFieldSelection(sel), trigger);
        if (markers != null) {
            markers.clearAll();
            markers.add(sel);
        }
    }

    public void setHighlight(ProgramSelection highlight) {
        this.fieldPanel.setHighlight(this.layoutModel.getFieldSelection(highlight));
        Program program = this.getProgram();
        MarkerSet markers = this.getHighlightMarkers(program);
        if (markers == null) {
            return;
        }
        markers.clearAll();
        if (highlight != null && program != null) {
            markers.setAddressSet(highlight);
        }
    }

    public ProgramSelection getProgramHighlight() {
        return this.layoutModel.getProgramSelection(this.fieldPanel.getHighlight());
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        if (this.listingModel == null) {
            return;
        }
        String text = FieldSelectionHelper.getFieldSelectionText((FieldSelection)selection, (FieldPanel)this.fieldPanel);
        if (this.stringSelectionListener != null) {
            this.stringSelectionListener.setStringSelection(text);
        }
        this.currentTextSelection = text;
        if (text != null) {
            return;
        }
        if (this.listingModel.getProgram() == null || this.programSelectionListener == null) {
            return;
        }
        ProgramSelection ps = this.layoutModel.getProgramSelection(selection);
        if (ps != null) {
            this.programSelectionListener.programSelectionChanged(ps, trigger);
        }
    }

    public String getTextSelection() {
        return this.currentTextSelection;
    }

    public void enablePropertyBasedColorModel(boolean b) {
        this.propertyBasedColorModel.setEnabled(b);
    }

    public void setNeverSroll() {
        this.scroller.setNeverScroll(true);
    }

    public void setFormatManager(FormatManager formatManager) {
        List<ListingHighlightProvider> highlightProviders = this.formatManager.getHighlightProviders();
        this.formatManager = formatManager;
        for (ListingHighlightProvider provider : highlightProviders) {
            this.formatManager.addHighlightProvider(provider);
        }
        if (this.headerPanel != null) {
            this.showHeader(false);
        }
        if (this.listingModel != null) {
            this.listingModel.setFormatManager(formatManager);
        }
        this.layoutModel.dataChanged(true);
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.add(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.remove(listener);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.fieldPanel.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.fieldPanel.removeFocusListener(l);
    }

    public void setUseMarkerNameSuffix(boolean b) {
        this.useMarkerNameSuffix = b;
    }

    public void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.removeChangeListener(this.markerChangeListener);
        }
        if (markerService != null) {
            markerService.addChangeListener(this.markerChangeListener);
        } else {
            this.doClearMarkers(this.getProgram());
        }
        this.markerService = markerService;
    }

    public void clearMarkers(Program program) {
        this.doClearMarkers(program);
    }

    private void doClearMarkers(Program program) {
        if (this.markerService == null) {
            return;
        }
        if (program == null) {
            return;
        }
        if (this.selectionMarkers != null) {
            this.markerService.removeMarker(this.selectionMarkers, program);
            this.selectionMarkers = null;
        }
        if (this.highlightMarkers != null) {
            this.markerService.removeMarker(this.highlightMarkers, program);
            this.highlightMarkers = null;
        }
        if (this.cursorMarkers != null) {
            this.markerService.removeMarker(this.cursorMarkers, program);
            this.cursorMarkers = null;
        }
    }

    public void setSelectionColor(Color color) {
        this.fieldPanel.setSelectionColor(color);
        if (this.selectionMarkers != null) {
            this.selectionMarkers.setMarkerColor(color);
        }
    }

    public void setHighlightColor(Color color) {
        this.fieldPanel.setHighlightColor(color);
        if (this.highlightMarkers != null) {
            this.highlightMarkers.setMarkerColor(color);
        }
    }

    private String getMarkerName(String baseName) {
        if (this.useMarkerNameSuffix) {
            return baseName + " " + this.marginOwnerId.toString();
        }
        return baseName;
    }

    private MarkerSet getSelectionMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.selectionMarkers != null) {
            return this.selectionMarkers;
        }
        String markerName = this.getMarkerName("Selection");
        Color color = this.fieldPanel.getSelectionColor();
        this.selectionMarkers = this.markerService.createAreaMarker(markerName, "Selection Display", program, 100, false, true, false, color);
        this.selectionMarkers.setOwnerId(this.marginOwnerId);
        return this.selectionMarkers;
    }

    private MarkerSet getHighlightMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.highlightMarkers != null) {
            return this.highlightMarkers;
        }
        String markerName = this.getMarkerName("Highlight");
        Color color = this.fieldPanel.getHighlightColor();
        this.highlightMarkers = this.markerService.createAreaMarker(markerName, "Highlight Display ", program, 50, false, true, false, color);
        this.highlightMarkers.setOwnerId(this.marginOwnerId);
        return this.highlightMarkers;
    }

    private MarkerSet getCursorMarkers(Program program) {
        if (this.markerService == null || program == null) {
            return null;
        }
        if (this.cursorMarkers != null) {
            return this.cursorMarkers;
        }
        String markerName = this.getMarkerName("Cursor");
        this.cursorMarkers = this.markerService.createPointMarker(markerName, "Cursor Location", program, 200, true, true, this.isHighlightCursorLineEnabled, this.cursorLineHighlightColor, CURSOR_LOC_ICON);
        this.cursorMarkers.setOwnerId(this.marginOwnerId);
        return this.cursorMarkers;
    }

    public void setCursorHighlightColor(Color cursorHighlightColor) {
        this.cursorLineHighlightColor = cursorHighlightColor;
        if (this.cursorMarkers != null) {
            this.cursorMarkers.setMarkerColor(cursorHighlightColor);
        }
    }

    public void setHighlightCursorLineEnabled(boolean b) {
        this.isHighlightCursorLineEnabled = b;
        if (this.cursorMarkers != null) {
            this.cursorMarkers.setColoringBackground(b);
        }
    }

    public void setCursorMarkerAddress(Address address) {
        MarkerSet markers = this.getCursorMarkers(this.getProgram());
        if (markers != null) {
            markers.clearAll();
            markers.add(address);
        }
    }

    public void updateBackgroundColorModel() {
        if (this.markerService == null) {
            this.setBackgroundColorModel(null);
        } else {
            AddressIndexMap indexMap = this.getAddressIndexMap();
            this.setBackgroundColorModel(new MarkerServiceBackgroundColorModel(this.markerService, indexMap));
        }
    }

    private class FocusingMouseListener
    extends MouseAdapter {
        private FocusingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ListingPanel.this.fieldPanel.requestFocus();
        }
    }

    private class MarkerChangeListener
    implements ChangeListener {
        private MarkerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ListingPanel.this.fieldPanel.repaint();
        }
    }
}

