/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.ContextDescriptorFlags;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetSingletonMetadataInitialization
extends SwiftTypeMetadataStructure {
    private ContextDescriptorFlags flags;
    private int initializationCache;
    private int incompleteMetadata;
    private int resilientPattern;
    private int completionFunction;

    public TargetSingletonMetadataInitialization(BinaryReader reader, ContextDescriptorFlags flags) throws IOException {
        super(reader.getPointerIndex());
        this.flags = flags;
        this.initializationCache = reader.readNextInt();
        this.resilientPattern = this.incompleteMetadata = reader.readNextInt();
        this.completionFunction = reader.readNextInt();
    }

    public int getInitializationCache() {
        return this.initializationCache;
    }

    public int getIncompleteMetadata() {
        return !this.flags.hasClassResilientSuperclass() ? this.incompleteMetadata : 0;
    }

    public int getResilientPattern() {
        return this.flags.hasClassResilientSuperclass() ? this.resilientPattern : 0;
    }

    public int getCompletionFunction() {
        return this.completionFunction;
    }

    @Override
    public String getStructureName() {
        return TargetSingletonMetadataInitialization.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "singleton metadata initialization";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        UnionDataType union = new UnionDataType(CATEGORY_PATH, "Union_IncompleteMetadata_ResilientPattern");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "IncompleteMetadata", "The incomplete metadata, for structs, enums and classes without resilient ancestry.");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "ResilientPattern", "If the classes descriptor has a resilient superclass, this points at a pattern used to allcoate and initialize metadata for this class, since its size and contents is not known at compile time.");
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "InitializationCache", "The initialization cache.");
        struct.add((DataType)union, union.getName(), null);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "CompletionFunction", "The completion function. The pattern will always be null, even for a resilient class.");
        return struct;
    }
}

