/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetObjCResilientClassStubInfo
extends SwiftTypeMetadataStructure {
    private int stub;

    public TargetObjCResilientClassStubInfo(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.stub = reader.readNextInt();
    }

    public int getStub() {
        return this.stub;
    }

    @Override
    public String getStructureName() {
        return this.getMyStructureName();
    }

    @Override
    public String getDescription() {
        return "objc resilient class stub";
    }

    private final String getMyStructureName() {
        return TargetObjCResilientClassStubInfo.class.getSimpleName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getMyStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Stub", "A relative pointer to an Objective-C resilient class stub.");
        return struct;
    }
}

