/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetMethodOverrideDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 8;
    private int classPtr;
    private int methodPtr;
    private int impl;

    public TargetMethodOverrideDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.classPtr = reader.readNextInt();
        this.methodPtr = reader.readNextInt();
        this.impl = reader.readNextInt();
    }

    public int getClassPtr() {
        return this.classPtr;
    }

    public int getMethodPtr() {
        return this.methodPtr;
    }

    public int getImpl() {
        return this.impl;
    }

    @Override
    public String getStructureName() {
        return TargetMethodOverrideDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "method override descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE_MASKED, "Class", "The class containing the base method.");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE_MASKED, "Method", "The base method.");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Impl", "The implementation of the override");
        return struct;
    }
}

