/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.GenericContextDescriptorFlags;
import ghidra.app.util.bin.format.swift.types.GenericParamDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetGenericRequirementsDescriptor;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TargetGenericContextDescriptorHeader
extends SwiftTypeMetadataStructure {
    private int numParams;
    private int numRequirements;
    private int numKeyArguments;
    private GenericContextDescriptorFlags flags;
    private List<GenericParamDescriptor> params = new ArrayList<GenericParamDescriptor>();
    private List<TargetGenericRequirementsDescriptor> requirements = new ArrayList<TargetGenericRequirementsDescriptor>();

    public TargetGenericContextDescriptorHeader(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        int i;
        this.numParams = reader.readNextUnsignedShort();
        this.numRequirements = reader.readNextUnsignedShort();
        this.numKeyArguments = reader.readNextUnsignedShort();
        this.flags = new GenericContextDescriptorFlags(reader);
        for (i = 0; i < this.numParams; ++i) {
            this.params.add(new GenericParamDescriptor(reader));
        }
        reader.setPointerIndex(reader.getPointerIndex() + 3L & 0xFFFFFFFFFFFFFFFCL);
        for (i = 0; i < this.numRequirements; ++i) {
            this.requirements.add(new TargetGenericRequirementsDescriptor(reader));
        }
    }

    public int getNumParams() {
        return this.numParams;
    }

    public int getNumRequirements() {
        return this.numRequirements;
    }

    public int getNumKeyArguments() {
        return this.numKeyArguments;
    }

    public GenericContextDescriptorFlags getFlags() {
        return this.flags;
    }

    public List<GenericParamDescriptor> getParams() {
        return this.params;
    }

    public List<TargetGenericRequirementsDescriptor> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<SwiftTypeMetadataStructure> getTrailingObjects() {
        ArrayList<SwiftTypeMetadataStructure> ret = new ArrayList<SwiftTypeMetadataStructure>();
        ret.addAll(this.params);
        ret.addAll(this.requirements);
        return ret;
    }

    @Override
    public String getStructureName() {
        return TargetGenericContextDescriptorHeader.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic context descriptor header";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(WORD, "NumParams", "The number of (source-written) generic parameters, and thus the number of GenericParamDescriptors associated with this context.");
        struct.add(WORD, "NumRequirements", "The number of GenericRequirementDescriptors in this generic signature.");
        struct.add(WORD, "NumKeyArguments", "The size of the key area of the argument layout, in words.");
        struct.add(this.flags.toDataType(), "Flags", "");
        return struct;
    }
}

