/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.ExtraClassDescriptorFlags;
import ghidra.app.util.bin.format.swift.types.InvertibleProtocolSet;
import ghidra.app.util.bin.format.swift.types.TargetForeignMetadataInitialization;
import ghidra.app.util.bin.format.swift.types.TargetMethodDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetMethodOverrideDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetObjCResilientClassStubInfo;
import ghidra.app.util.bin.format.swift.types.TargetOverrideTableHeader;
import ghidra.app.util.bin.format.swift.types.TargetResilientSuperclass;
import ghidra.app.util.bin.format.swift.types.TargetSingletonMetadataInitialization;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetTypeGenericContextDescriptorHeader;
import ghidra.app.util.bin.format.swift.types.TargetVTableDescriptorHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class TargetClassDescriptor
extends TargetTypeContextDescriptor {
    private int superclassType;
    private int metadataNegativeSizeInWords;
    private int resilientMetadataBounds;
    private int metadataPositiveSizeInWords;
    private ExtraClassDescriptorFlags extraClassFlags;
    private int numImmediateMembers;
    private int numFields;
    private int fieldOffsetVectorOffset;
    private TargetTypeGenericContextDescriptorHeader genericHeader;
    private TargetResilientSuperclass resilientSuperclass;
    private TargetSingletonMetadataInitialization singleton;
    private TargetForeignMetadataInitialization foreign;
    private TargetVTableDescriptorHeader vtableHeader;
    private List<TargetMethodDescriptor> methodDescriptors = new ArrayList<TargetMethodDescriptor>();
    private TargetOverrideTableHeader overrideHeader;
    private List<TargetMethodOverrideDescriptor> methodOverrideDescriptors = new ArrayList<TargetMethodOverrideDescriptor>();
    private TargetObjCResilientClassStubInfo objcResilientClassStub;
    private InvertibleProtocolSet invertibleProtocolSet;

    public TargetClassDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        int i;
        this.superclassType = reader.readNextInt();
        this.metadataNegativeSizeInWords = this.resilientMetadataBounds = reader.readNextInt();
        this.extraClassFlags = new ExtraClassDescriptorFlags(reader);
        this.metadataPositiveSizeInWords = this.extraClassFlags.getFlags();
        this.numImmediateMembers = reader.readNextInt();
        this.numFields = reader.readNextInt();
        this.fieldOffsetVectorOffset = reader.readNextInt();
        if (this.flags.isGeneric()) {
            this.genericHeader = new TargetTypeGenericContextDescriptorHeader(reader);
        }
        if (this.flags.hasClassResilientSuperclass()) {
            this.resilientSuperclass = new TargetResilientSuperclass(reader);
        }
        switch (this.flags.getMetadataInitialization()) {
            case NoMetadataInitialization: {
                break;
            }
            case SingletonMetadataInitialization: {
                this.singleton = new TargetSingletonMetadataInitialization(reader, this.flags);
                break;
            }
            case ForeignMetadataInitialization: {
                this.foreign = new TargetForeignMetadataInitialization(reader);
            }
        }
        if (this.flags.hasClassVTable()) {
            this.vtableHeader = new TargetVTableDescriptorHeader(reader);
            i = 0;
            while ((long)i < this.vtableHeader.getVTableSize()) {
                this.methodDescriptors.add(new TargetMethodDescriptor(reader));
                ++i;
            }
        }
        if (this.flags.hasClassOverrideTable()) {
            this.overrideHeader = new TargetOverrideTableHeader(reader);
            i = 0;
            while ((long)i < this.overrideHeader.getNumEntries()) {
                this.methodOverrideDescriptors.add(new TargetMethodOverrideDescriptor(reader));
                ++i;
            }
        }
        if (this.flags.hasClassResilientSuperclass() && this.extraClassFlags.hasObjcResilientClassStub()) {
            this.objcResilientClassStub = new TargetObjCResilientClassStubInfo(reader);
        }
        if (this.flags.isGeneric() && this.flags.hasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter()) {
            throw new IOException("Unimplemented TargetCanonicalSpecializedMetadatas detected.");
        }
        if (this.flags.hasInvertableProtocols()) {
            this.invertibleProtocolSet = new InvertibleProtocolSet(reader);
        }
        if (!this.flags.isGeneric() && this.flags.hasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter()) {
            throw new IOException("Unimplemented TargetSingletonMetadataPointer detected.");
        }
        if (this.flags.hasClassDefaultOverrideTable()) {
            throw new IOException("Unimplemented TargetMethodDefaultOverride detected.");
        }
    }

    public int getSuperclassType() {
        return this.superclassType;
    }

    public int getResilientMetadataBounds() {
        return this.flags.hasClassResilientSuperclass() ? this.resilientMetadataBounds : 0;
    }

    public int getMetadataNegativeSizeInWords() {
        return !this.flags.hasClassResilientSuperclass() ? this.metadataNegativeSizeInWords : 0;
    }

    public ExtraClassDescriptorFlags getExtraClassDescriptorFlags() {
        return this.flags.hasClassResilientSuperclass() ? this.extraClassFlags : null;
    }

    public int getMetadataPositiveSizeInWords() {
        return !this.flags.hasClassResilientSuperclass() ? this.metadataPositiveSizeInWords : 0;
    }

    public int getNumImmediateMembers() {
        return this.numImmediateMembers;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public int getFieldOffsetVectorOffset() {
        return this.fieldOffsetVectorOffset;
    }

    public TargetTypeGenericContextDescriptorHeader getGenericHeader() {
        return this.genericHeader;
    }

    public TargetResilientSuperclass getResilientSuperclass() {
        return this.resilientSuperclass;
    }

    public TargetSingletonMetadataInitialization getTargetSingletonMetadataInitialization() {
        return this.singleton;
    }

    public TargetForeignMetadataInitialization getTargetForeignMetadataInitialization() {
        return this.foreign;
    }

    public TargetVTableDescriptorHeader getVTableDescriptorHeader() {
        return this.vtableHeader;
    }

    public List<TargetMethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public TargetOverrideTableHeader getTargetOverrideTableHeader() {
        return this.overrideHeader;
    }

    public List<TargetMethodOverrideDescriptor> getMethodOverrideDescriptors() {
        return this.methodOverrideDescriptors;
    }

    public TargetObjCResilientClassStubInfo getObjcResilientClassStub() {
        return this.objcResilientClassStub;
    }

    public InvertibleProtocolSet getInvertibleProtocolSet() {
        return this.invertibleProtocolSet;
    }

    @Override
    public List<SwiftTypeMetadataStructure> getTrailingObjects() {
        ArrayList<SwiftTypeMetadataStructure> ret = new ArrayList<SwiftTypeMetadataStructure>();
        if (this.genericHeader != null) {
            ret.add(this.genericHeader);
            ret.addAll(this.genericHeader.getTrailingObjects());
        }
        if (this.resilientSuperclass != null) {
            ret.add(this.resilientSuperclass);
        }
        if (this.singleton != null) {
            ret.add(this.singleton);
        }
        if (this.foreign != null) {
            ret.add(this.foreign);
        }
        if (this.vtableHeader != null) {
            ret.add(this.vtableHeader);
            ret.addAll(this.methodDescriptors);
        }
        if (this.overrideHeader != null) {
            ret.add(this.overrideHeader);
            ret.addAll(this.methodOverrideDescriptors);
        }
        if (this.objcResilientClassStub != null) {
            ret.add(this.objcResilientClassStub);
        }
        if (this.invertibleProtocolSet != null) {
            ret.add(this.invertibleProtocolSet);
        }
        return ret;
    }

    @Override
    public String getStructureName() {
        return TargetClassDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "class descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        UnionDataType union1 = new UnionDataType(CATEGORY_PATH, "Union_MetadataNegativeSizeInWords_ResilientMetadataBounds");
        union1.add(DWORD, "MetadataNegativeSizeInWords", "If this descriptor does not have a resilient superclass, this is the negative size of metadata objects of this class (in words)");
        union1.add((DataType)SwiftUtils.PTR_RELATIVE, "ResilientMetadataBounds", "If this descriptor has a resilient superclass, this is a reference to a cache holding the metadata's extends.");
        UnionDataType union2 = new UnionDataType(CATEGORY_PATH, "Union_MetadataPositiveSizeInWords/ExtraClassFlags");
        union2.add(DWORD, "MetadataPositiveSizeInWords", "If this descriptor does not have a resilient superclass, this is the positive size of metadata objects of this class (in words)");
        union2.add(this.extraClassFlags.toDataType(), "ExtraClassFlags", "Otherwise, these flags are used to do things like indicating the presence of an Objective-C resilient class stub.");
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "SuperclassType", "The type of the superclass, expressed as a mangled type name that can refer to the generic arguments of the subclass type");
        struct.add((DataType)union1, "MetadataNegativeSizeInWords/ResilientMetadataBounds", null);
        struct.add((DataType)union2, "MetadataPositiveSizeInWords/ExtraClassFlags", null);
        struct.add(DWORD, "NumImmediateMembers", "The number of additional members added by this class to the class metadata");
        struct.add(DWORD, "NumFields", "The number of stored properties in the class, not including its superclasses. If there is a field offset vector, this is its length.");
        struct.add(DWORD, "FieldOffsetVectorOffset", "The offset of the field offset vector for this class's stored properties in its metadata, in words. 0 means there is no field offset vector.");
        return struct;
    }
}

