/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum ProtocolRequirementKind implements StructConverter
{
    BaseProtocol(0),
    Method(1),
    Init(2),
    Getter(3),
    Setter(4),
    ReadCoroutine(5),
    ModifyCoroutine(6),
    AssociatedTypeAccessFunction(7),
    AssociatedConformanceAccessFunction(8);

    private int value;

    private ProtocolRequirementKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ProtocolRequirementKind valueOf(int value) {
        return Arrays.stream(ProtocolRequirementKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, ProtocolRequirementKind.class.getSimpleName(), 1);
        for (ProtocolRequirementKind kind : ProtocolRequirementKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

