/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class MultiPayloadEnumDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    public static final int PEEK_SIZE = 8;
    private String typeName;
    private int[] contents;

    public MultiPayloadEnumDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.typeName = reader.readNext(SwiftUtils::relativeString);
        int size = reader.readNextInt() >> 16 & 0xFFFF;
        reader.setPointerIndex(reader.getPointerIndex() - 4L);
        this.contents = reader.readNextIntArray(size);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int[] getContents() {
        return this.contents;
    }

    public long getContentsSize() {
        return this.contents.length * 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int peekContentsSize(BinaryReader reader) throws IOException {
        long origIndex = reader.getPointerIndex();
        try {
            reader.readNext(SwiftUtils::relativeString);
            int n = reader.readNextInt() >> 16 & 0xFFFF;
            return n;
        }
        finally {
            reader.setPointerIndex(origIndex);
        }
    }

    @Override
    public String getStructureName() {
        return MultiPayloadEnumDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "multipayload enum descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return SwiftUtils.PTR_STRING;
    }
}

