/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum MetadataInitializationKind implements StructConverter
{
    NoMetadataInitialization(0),
    SingletonMetadataInitialization(1),
    ForeignMetadataInitialization(2);

    private int value;

    private MetadataInitializationKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MetadataInitializationKind valueOf(int value) {
        return Arrays.stream(MetadataInitializationKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, MetadataInitializationKind.class.getSimpleName(), 1);
        for (MetadataInitializationKind kind : MetadataInitializationKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

