/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum InvertibleProtocolKind implements StructConverter
{
    Copyable(0),
    Escapable(1);

    private int bit;

    private InvertibleProtocolKind(int bit) {
        this.bit = bit;
    }

    public int getBit() {
        return this.bit;
    }

    public static Set<InvertibleProtocolKind> valueOf(short value) {
        HashSet<InvertibleProtocolKind> set = new HashSet<InvertibleProtocolKind>();
        for (int i = 0; i < 16; ++i) {
            int bitPos = i;
            int bit = value >> bitPos & 1;
            if (bit == 0) continue;
            Arrays.stream(InvertibleProtocolKind.values()).filter(e -> e.getBit() == bitPos).findFirst().ifPresent(set::add);
        }
        return set;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, InvertibleProtocolKind.class.getSimpleName(), 2);
        for (InvertibleProtocolKind kind : InvertibleProtocolKind.values()) {
            dt.add(kind.name(), (long)(1 << kind.getBit()));
        }
        return dt;
    }
}

