/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.GenericRequirementKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GenericRequirementFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private int flags;

    public GenericRequirementFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public GenericRequirementKind getKind() {
        return GenericRequirementKind.valueOf(this.flags & 0x1F);
    }

    public boolean isPackRequirement() {
        return (this.flags & 0x20) != 0;
    }

    public boolean hasKeyArgument() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isValueRequirement() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public String getStructureName() {
        return GenericRequirementFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic requirement flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 4);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(GenericRequirementKind.values()[0].toDataType(), 5, "kind", null);
            struct.addBitField(BOOL, 1, "isPackRequirement", "If true, the subject type of the requirement is a pack.");
            struct.addBitField(BOOL, 1, "legacy", "Don't set 0x40 for compatibility with pre-Swift 5.8 runtimes");
            struct.addBitField(BOOL, 1, "hasKeyArgument", null);
            struct.addBitField(BOOL, 1, "isValueRequirement", "If true, the subject type of the requirement is a value.");
            struct.addBitField(DWORD, 23, "reserved", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

