/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.GenericParamKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GenericParamDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 1;
    private int value;

    public GenericParamDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.value = reader.readNextUnsignedByte();
    }

    public int getValue() {
        return this.value;
    }

    public GenericParamKind getKind() {
        return GenericParamKind.valueOf(this.value & 0x3F);
    }

    public boolean hasKeyArgument() {
        return (this.value & 0x80) != 0;
    }

    @Override
    public String getStructureName() {
        return GenericParamDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic param descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 1);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(GenericParamKind.values()[0].toDataType(), 7, "kind", null);
            struct.addBitField(BOOL, 1, "HasKeyArgument", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

